/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.data;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueVisitor;

public class DateData
implements DataValue {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private Date mValue;

    public DateData(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.mValue = date;
    }

    public void accept(DataValueVisitor dataValueVisitor) {
        if (dataValueVisitor == null) {
            throw new IllegalArgumentException("visitor must not be null");
        }
        dataValueVisitor.visitDateData(this);
    }

    public boolean isFinalBlock() {
        return false;
    }

    public Date getDate() {
        return this.mValue;
    }

    public Calendar getCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.mValue);
        return calendar;
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
        String string = simpleDateFormat.format(this.mValue);
        string = string.substring(0, string.length() - 2) + ":" + string.substring(string.length() - 2);
        return string;
    }

    public int hashCode() {
        return this.mValue.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DateData)) {
            return false;
        }
        DateData dateData = (DateData)object;
        return this.mValue.equals(dateData.mValue);
    }
}

