/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.data;

import java.util.Arrays;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueVisitor;

public class BinaryData
implements DataValue {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private final byte[] mValue;

    public BinaryData(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.mValue = byArray;
    }

    public byte[] getBytes() {
        return this.mValue;
    }

    public void accept(DataValueVisitor dataValueVisitor) {
        if (dataValueVisitor == null) {
            throw new IllegalArgumentException("visitor must not be null");
        }
        dataValueVisitor.visitBinaryData(this);
    }

    public boolean isFinalBlock() {
        return false;
    }

    public String toString() {
        return Base64.encode((byte[])this.mValue);
    }

    public int hashCode() {
        return 1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BinaryData)) {
            return false;
        }
        BinaryData binaryData = (BinaryData)object;
        return Arrays.equals(this.mValue, binaryData.mValue);
    }
}

