/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.common;

import uk.org.ogsadai.common.MalformedIDException;

public class ID {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2002 - 2007";
    private final String mLocalPart;
    private final String mQualifier;

    public ID(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("The localPart argument must not be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("The qualifier argument must not be null.");
        }
        this.mLocalPart = string;
        this.mQualifier = string2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ID(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The compositeName argument must not be null.");
        }
        String string2 = string.trim();
        int n = string2.lastIndexOf(46);
        if (n == -1) {
            if (string2.length() <= 0) throw new MalformedIDException(string);
            this.mLocalPart = string2;
            this.mQualifier = "";
            return;
        } else {
            if (string2.length() < 3 || n <= 0 || n >= string2.length() - 1 || string2.charAt(0) == '.') throw new MalformedIDException(string);
            this.mLocalPart = string2.substring(n + 1);
            this.mQualifier = string2.substring(0, n);
        }
    }

    public String getLocalPart() {
        return this.mLocalPart;
    }

    public String getNamespace() {
        return this.mQualifier;
    }

    public String toString() {
        if (this.mQualifier.length() == 0) {
            return this.mLocalPart;
        }
        return this.mQualifier + "." + this.mLocalPart;
    }

    public boolean equals(Object object) {
        if (object instanceof ID) {
            ID iD = (ID)object;
            return iD.getLocalPart().equals(this.getLocalPart()) && iD.getNamespace().equals(this.getNamespace());
        }
        return false;
    }

    public int hashCode() {
        return 13795 + this.getLocalPart().hashCode() + this.getNamespace().hashCode();
    }
}

