/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.activity.request.status;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentHashMap;
import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import uk.org.ogsadai.activity.ActivityInstanceName;
import uk.org.ogsadai.activity.ActivityStatus;
import uk.org.ogsadai.activity.event.Warning;
import uk.org.ogsadai.activity.request.status.ActivityProcessingStatus;
import uk.org.ogsadai.activity.request.status.ActivityResultKey;
import uk.org.ogsadai.common.ID;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.resource.ResourceID;
import uk.org.ogsadai.resource.request.RequestExecutionStatus;
import uk.org.ogsadai.resource.request.RequestStatus;

public class SimpleRequestStatus
implements RequestStatus {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2007.";
    private volatile RequestExecutionStatus mStatus = RequestExecutionStatus.UNSTARTED;
    private volatile DAIException mRequestError;
    private ResourceID mRequestID;
    private Map mResults = new ConcurrentHashMap();
    private ConcurrentMap mActivityStatus = new ConcurrentHashMap();
    private volatile boolean mActivityIsInError = false;

    public SimpleRequestStatus(ResourceID resourceID) {
        this.setRequestID(resourceID);
    }

    public void addResult(ActivityInstanceName activityInstanceName, String string, DataValue dataValue) {
        List list;
        ActivityResultKey activityResultKey = new ActivityResultKey(activityInstanceName, string);
        if (this.mResults.containsKey(activityResultKey)) {
            list = (List)this.mResults.get(activityResultKey);
        } else {
            list = Collections.synchronizedList(new LinkedList());
            this.mResults.put(activityResultKey, list);
        }
        list.add(dataValue);
    }

    public void setActivityStatus(ActivityInstanceName activityInstanceName, ActivityStatus activityStatus) {
        Object object;
        ActivityProcessingStatus activityProcessingStatus = (ActivityProcessingStatus)this.mActivityStatus.get((Object)activityInstanceName);
        if (activityProcessingStatus == null && (object = this.mActivityStatus.putIfAbsent((Object)activityInstanceName, (Object)(activityProcessingStatus = new ActivityProcessingStatus()))) != null) {
            activityProcessingStatus = (ActivityProcessingStatus)object;
        }
        activityProcessingStatus.setStatus(activityStatus);
    }

    public void setActivityError(ActivityInstanceName activityInstanceName, DAIException dAIException) {
        ActivityProcessingStatus activityProcessingStatus = new ActivityProcessingStatus();
        Object object = this.mActivityStatus.putIfAbsent((Object)activityInstanceName, (Object)activityProcessingStatus);
        if (object != null) {
            activityProcessingStatus = (ActivityProcessingStatus)object;
        }
        this.mActivityIsInError = true;
        activityProcessingStatus.setError(dAIException);
    }

    public Throwable getActivityError(ActivityInstanceName activityInstanceName) {
        ActivityProcessingStatus activityProcessingStatus = (ActivityProcessingStatus)this.mActivityStatus.get((Object)activityInstanceName);
        DAIException dAIException = null;
        if (activityProcessingStatus != null) {
            dAIException = activityProcessingStatus.getError();
        }
        return dAIException;
    }

    public void addActivityWarning(ActivityInstanceName activityInstanceName, Warning warning) {
        ActivityProcessingStatus activityProcessingStatus = new ActivityProcessingStatus();
        Object object = this.mActivityStatus.putIfAbsent((Object)activityInstanceName, (Object)activityProcessingStatus);
        if (object != null) {
            activityProcessingStatus = (ActivityProcessingStatus)object;
        }
        activityProcessingStatus.addWarning(warning);
    }

    public void setRequestExecutionStatus(RequestExecutionStatus requestExecutionStatus) {
        this.mStatus = this.mActivityIsInError ? (requestExecutionStatus == RequestExecutionStatus.PROCESSING ? RequestExecutionStatus.PROCESSING_WITH_ERROR : (requestExecutionStatus == RequestExecutionStatus.COMPLETED ? RequestExecutionStatus.COMPLETED_WITH_ERROR : requestExecutionStatus)) : requestExecutionStatus;
    }

    public void setRequestError(DAIException dAIException) {
        this.mRequestError = dAIException;
    }

    public DAIException getError() {
        return this.mRequestError;
    }

    public void setRequestID(ResourceID resourceID) {
        this.mRequestID = resourceID;
    }

    public RequestExecutionStatus getExecutionStatus() {
        return this.mStatus;
    }

    public ActivityStatus getActivityStatus(ActivityInstanceName activityInstanceName) {
        ActivityStatus activityStatus = null;
        ActivityProcessingStatus activityProcessingStatus = (ActivityProcessingStatus)this.mActivityStatus.get((Object)activityInstanceName);
        if (activityProcessingStatus != null) {
            activityStatus = activityProcessingStatus.getStatus();
        }
        return activityStatus;
    }

    public ActivityProcessingStatus getActivityProcessingStatus(ActivityInstanceName activityInstanceName) {
        ActivityProcessingStatus activityProcessingStatus = (ActivityProcessingStatus)this.mActivityStatus.get((Object)activityInstanceName);
        return activityProcessingStatus;
    }

    public ResourceID getRequestID() {
        return this.mRequestID;
    }

    public boolean hasData(ActivityInstanceName activityInstanceName, String string) {
        ActivityResultKey activityResultKey = new ActivityResultKey(activityInstanceName, string);
        return this.mResults.containsKey(activityResultKey);
    }

    public Iterator getDataValueIterator(ActivityInstanceName activityInstanceName, String string) {
        ActivityResultKey activityResultKey = new ActivityResultKey(activityInstanceName, string);
        if (this.mResults.containsKey(activityResultKey)) {
            List list = (List)this.mResults.get(activityResultKey);
            return new LinkedList(list).iterator();
        }
        return Collections.EMPTY_LIST.iterator();
    }

    public Iterator getActivities() {
        return this.mActivityStatus.entrySet().iterator();
    }

    public Iterator getActivityResults() {
        return this.mResults.entrySet().iterator();
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Request id=\"");
        stringBuffer.append(this.getRequestID());
        stringBuffer.append("\"\n");
        stringBuffer.append("Request status=\"");
        stringBuffer.append(this.mStatus);
        stringBuffer.append("\"\n");
        Object object2 = this.mResults.keySet().iterator();
        while (object2.hasNext()) {
            object = (ActivityResultKey)object2.next();
            List list = (List)this.mResults.get(object);
            stringBuffer.append("Result activityInstanceName=\"");
            stringBuffer.append(((ActivityResultKey)object).getActivityInstanceName());
            stringBuffer.append("\" resultName=\"");
            stringBuffer.append(((ActivityResultKey)object).getResultName());
            stringBuffer.append("\"\n");
            stringBuffer.append("Data:\n");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                stringBuffer.append("--DataItem--->");
                stringBuffer.append(e);
                stringBuffer.append("\n");
            }
        }
        object2 = this.mActivityStatus.keySet().iterator();
        while (object2.hasNext()) {
            object = (ActivityInstanceName)object2.next();
            stringBuffer.append("Activity instanceName=\"");
            stringBuffer.append(((ID)object).toString());
            stringBuffer.append("\" ");
            stringBuffer.append(this.mActivityStatus.get(object));
        }
        if (this.mRequestError != null) {
            stringBuffer.append("Error=\n");
            for (object2 = this.mRequestError; object2 != null; object2 = ((Throwable)object2).getCause()) {
                stringBuffer.append(object2);
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

