/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.resource;

import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import uk.org.ogsadai.client.toolkit.ResourcePropertyValue;
import uk.org.ogsadai.client.toolkit.exception.ClientToolkitException;
import uk.org.ogsadai.client.toolkit.exception.DOMParserConfigurationException;
import uk.org.ogsadai.exception.ResourcePropertyValueParseException;
import uk.org.ogsadai.resource.property.DatePropertyConvertor;
import uk.org.ogsadai.resource.property.NullableDatePropertyConvertor;
import uk.org.ogsadai.resource.property.StringPropertyConvertor;
import uk.org.ogsadai.util.xml.XML;

public class SimpleResourcePropertyValue
implements ResourcePropertyValue {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private Node[] mNodes;

    public SimpleResourcePropertyValue(String string) throws ClientToolkitException {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Text text = document.createTextNode(string);
            this.mNodes = new Node[]{text};
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new DOMParserConfigurationException(parserConfigurationException);
        }
    }

    public SimpleResourcePropertyValue(Node[] nodeArray) {
        this.mNodes = nodeArray;
    }

    public SimpleResourcePropertyValue(NodeList nodeList) {
        this.mNodes = new Node[nodeList.getLength()];
        for (int i = 0; i < this.mNodes.length; ++i) {
            this.mNodes[i] = nodeList.item(i);
        }
    }

    public Node[] getNodes() {
        return this.mNodes;
    }

    public String getString() throws ResourcePropertyValueParseException {
        return StringPropertyConvertor.deserialize((Node[])this.mNodes);
    }

    public Date getDate() throws ResourcePropertyValueParseException {
        return DatePropertyConvertor.deserialize((Node[])this.mNodes);
    }

    public Date getNullableDate() throws ResourcePropertyValueParseException {
        return NullableDatePropertyConvertor.deserialize((Node[])this.mNodes);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Property Values: ");
        stringBuffer.append("\n");
        for (int i = 0; i < this.mNodes.length; ++i) {
            stringBuffer.append(XML.toString((Node)this.mNodes[i]));
        }
        return stringBuffer.toString();
    }
}

