/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.resource;

import org.w3c.dom.Element;
import org.w3c.dom.Text;
import uk.org.ogsadai.client.toolkit.RequestResource;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.ResourceProperty;
import uk.org.ogsadai.client.toolkit.SessionResource;
import uk.org.ogsadai.client.toolkit.Workflow;
import uk.org.ogsadai.client.toolkit.exception.ClientServerCompatibilityException;
import uk.org.ogsadai.client.toolkit.exception.ClientToolkitException;
import uk.org.ogsadai.client.toolkit.exception.PropertyNameInvalidException;
import uk.org.ogsadai.client.toolkit.exception.RequestCompletedWithErrorException;
import uk.org.ogsadai.client.toolkit.exception.RequestErrorException;
import uk.org.ogsadai.client.toolkit.exception.RequestExecutionException;
import uk.org.ogsadai.client.toolkit.exception.RequestTerminatedException;
import uk.org.ogsadai.client.toolkit.exception.ResourcePropertyParseException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerCommsException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.TimeoutException;
import uk.org.ogsadai.client.toolkit.exception.UnsupportedPropertyTypeException;
import uk.org.ogsadai.client.toolkit.property.convertor.RequestExecutionStatusXMLConvertor;
import uk.org.ogsadai.client.toolkit.property.convertor.RequestStatusXMLConvertor;
import uk.org.ogsadai.client.toolkit.resource.ResourcePropertyUtilities;
import uk.org.ogsadai.client.toolkit.resource.ResourceWrapper;
import uk.org.ogsadai.resource.ResourcePropertyNames;
import uk.org.ogsadai.resource.property.ActivitiesMetaData;
import uk.org.ogsadai.resource.request.RequestExecutionStatus;
import uk.org.ogsadai.resource.request.RequestStatus;

public class SimpleRequestResource
extends ResourceWrapper
implements RequestResource {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private RequestExecutionStatus mRequestExecutionStatus = null;
    private RequestStatus mRequestStatus = null;
    private boolean mIsResultPassedToWorkflow = false;
    private Workflow mRequestWorkflow;
    private SessionResource mSessionResource;

    public SimpleRequestResource(Resource resource) {
        super(resource);
    }

    public RequestExecutionStatus getRequestExecutionStatus() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        if (this.mRequestExecutionStatus == null || !this.mRequestExecutionStatus.hasFinished()) {
            this.mRequestExecutionStatus = this.fetchExecutionStatus();
        }
        return this.mRequestExecutionStatus;
    }

    public boolean hasSession() {
        return this.mSessionResource != null;
    }

    public SessionResource getSessionResource() {
        return this.mSessionResource;
    }

    public void setSessionResource(SessionResource sessionResource) {
        this.mSessionResource = sessionResource;
    }

    public void setRequestWorkflow(Workflow workflow) {
        this.mRequestWorkflow = workflow;
    }

    public void setRequestStatus(RequestStatus requestStatus) {
        this.mRequestStatus = requestStatus;
        this.mRequestExecutionStatus = requestStatus.getExecutionStatus();
        this.passRequestStatusToWorkflow();
    }

    public RequestStatus getRequestStatus() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        if (this.mRequestStatus == null || !this.mRequestStatus.getExecutionStatus().hasFinished()) {
            this.setRequestStatus(this.fetchRequestStatus());
        }
        return this.mRequestStatus;
    }

    public RequestStatus getLocalRequestStatus() throws ClientToolkitException {
        return this.mRequestStatus;
    }

    public ActivitiesMetaData getActivityDetails() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        return ResourcePropertyUtilities.getResourcePropertyAsActivitiesMetaData(this, ResourcePropertyNames.SUPPORTED_ACTIVITIES);
    }

    public void pollUntilRequestStarted(int n) throws RequestErrorException, ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        try {
            this.pollUntilRequestStarted(n, -1);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void pollUntilRequestStarted(int n, int n2) throws RequestErrorException, TimeoutException, ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        boolean bl = false;
        if (n <= 0) {
            throw new IllegalArgumentException("pollInterval must be > 0 : " + n);
        }
        if (n2 <= 0) {
            bl = true;
        }
        int n3 = n2 / n + 1;
        RequestExecutionStatus requestExecutionStatus = null;
        boolean bl2 = false;
        for (int i = 0; (bl || i < n3) && !bl2; ++i) {
            requestExecutionStatus = this.fetchExecutionStatus();
            if (requestExecutionStatus.hasStarted()) {
                bl2 = true;
            }
            if (requestExecutionStatus == RequestExecutionStatus.ERROR) {
                RequestStatus requestStatus = this.getRequestStatus();
                throw new RequestErrorException(this, requestStatus);
            }
            if (!bl2) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!bl) continue;
            i = 0;
        }
        if (!bl2) {
            throw new TimeoutException();
        }
    }

    public void pollUntilRequestCompleted(int n) throws RequestExecutionException, ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        try {
            this.pollUntilRequestCompleted(n, -1);
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    public void pollUntilRequestCompleted(int n, int n2) throws RequestExecutionException, TimeoutException, ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        boolean bl = false;
        if (n <= 0) {
            throw new IllegalArgumentException("pollInterval must be > 0 : " + n);
        }
        if (n2 <= 0) {
            bl = true;
        }
        int n3 = n2 / n + 1;
        RequestExecutionStatus requestExecutionStatus = null;
        boolean bl2 = false;
        for (int i = 0; (bl || i < n3) && !bl2; ++i) {
            requestExecutionStatus = this.fetchExecutionStatus();
            if (requestExecutionStatus == RequestExecutionStatus.COMPLETED) {
                bl2 = true;
            } else {
                if (requestExecutionStatus == RequestExecutionStatus.ERROR) {
                    RequestStatus requestStatus = this.getRequestStatus();
                    throw new RequestErrorException(this, requestStatus);
                }
                if (requestExecutionStatus == RequestExecutionStatus.TERMINATED) {
                    throw new RequestTerminatedException(this);
                }
                if (requestExecutionStatus == RequestExecutionStatus.COMPLETED_WITH_ERROR) {
                    throw new RequestCompletedWithErrorException(this);
                }
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (!bl) continue;
            i = 0;
        }
        if (!bl2) {
            throw new TimeoutException();
        }
    }

    protected RequestStatus fetchRequestStatus() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        try {
            ResourceProperty resourceProperty = this.getResourceProperty(ResourcePropertyNames.REQUEST_STATUS);
            RequestStatus requestStatus = RequestStatusXMLConvertor.convert((Element)resourceProperty.getValues()[0].getNodes()[0]);
            return requestStatus;
        }
        catch (ClassCastException classCastException) {
            throw new ResourcePropertyParseException(ResourcePropertyNames.REQUEST_STATUS, classCastException);
        }
        catch (PropertyNameInvalidException propertyNameInvalidException) {
            throw new UnsupportedPropertyTypeException(propertyNameInvalidException.getResourcePropertyName());
        }
    }

    protected RequestExecutionStatus fetchExecutionStatus() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        try {
            ResourceProperty resourceProperty = this.getResourceProperty(ResourcePropertyNames.REQUEST_EXECUTION_STATUS);
            RequestExecutionStatus requestExecutionStatus = RequestExecutionStatusXMLConvertor.convert((Text)resourceProperty.getValues()[0].getNodes()[0]);
            return requestExecutionStatus;
        }
        catch (ClassCastException classCastException) {
            throw new ResourcePropertyParseException(ResourcePropertyNames.REQUEST_EXECUTION_STATUS, classCastException);
        }
        catch (PropertyNameInvalidException propertyNameInvalidException) {
            throw new UnsupportedPropertyTypeException(propertyNameInvalidException.getResourcePropertyName());
        }
    }

    private void passRequestStatusToWorkflow() {
        if (!this.mIsResultPassedToWorkflow && this.mRequestStatus.getExecutionStatus().hasFinished()) {
            this.mRequestWorkflow.getRequestAndStatusHandler().processRequestStatus(this.mRequestStatus);
            this.mIsResultPassedToWorkflow = true;
        }
    }
}

