/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.resource;

import java.util.Date;
import org.w3c.dom.Node;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.ResourceProperty;
import uk.org.ogsadai.client.toolkit.ResourcePropertyValue;
import uk.org.ogsadai.client.toolkit.exception.ClientServerCompatibilityException;
import uk.org.ogsadai.client.toolkit.exception.PropertyNameInvalidException;
import uk.org.ogsadai.client.toolkit.exception.ResourcePropertyParseException;
import uk.org.ogsadai.client.toolkit.exception.ResourcePropertyValueCountException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerCommsException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.UnsupportedPropertyTypeException;
import uk.org.ogsadai.exception.ResourcePropertyValueParseException;
import uk.org.ogsadai.resource.ResourcePropertyName;
import uk.org.ogsadai.resource.property.ActivitiesMetaData;
import uk.org.ogsadai.resource.property.ActivitiesMetaDataPropertyConvertor;
import uk.org.ogsadai.resource.property.DatePropertyConvertor;
import uk.org.ogsadai.resource.property.NullableDatePropertyConvertor;
import uk.org.ogsadai.resource.property.StringPropertyConvertor;

public class ResourcePropertyUtilities {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";

    public static String getResourcePropertyAsString(Resource resource, ResourcePropertyName resourcePropertyName) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException {
        try {
            ResourcePropertyValue resourcePropertyValue = ResourcePropertyUtilities.getSingleResourcePropertyValue(resource, resourcePropertyName);
            String string = StringPropertyConvertor.deserialize((Node[])resourcePropertyValue.getNodes());
            return string;
        }
        catch (ResourcePropertyValueParseException resourcePropertyValueParseException) {
            throw new ResourcePropertyParseException(resourcePropertyName, resourcePropertyValueParseException);
        }
    }

    public static long getResourcePropertyAsLong(Resource resource, ResourcePropertyName resourcePropertyName) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException {
        try {
            String string = ResourcePropertyUtilities.getResourcePropertyAsString(resource, resourcePropertyName);
            return Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ResourcePropertyParseException(resourcePropertyName, numberFormatException);
        }
    }

    public static ActivitiesMetaData getResourcePropertyAsActivitiesMetaData(Resource resource, ResourcePropertyName resourcePropertyName) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException {
        try {
            ResourcePropertyValue resourcePropertyValue = ResourcePropertyUtilities.getSingleResourcePropertyValue(resource, resourcePropertyName);
            ActivitiesMetaData activitiesMetaData = ActivitiesMetaDataPropertyConvertor.deserialize((Node[])resourcePropertyValue.getNodes());
            return activitiesMetaData;
        }
        catch (ResourcePropertyValueParseException resourcePropertyValueParseException) {
            throw new ResourcePropertyParseException(resourcePropertyName, resourcePropertyValueParseException);
        }
    }

    public static Date getResourcePropertyAsDate(Resource resource, ResourcePropertyName resourcePropertyName) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException {
        try {
            ResourcePropertyValue resourcePropertyValue = ResourcePropertyUtilities.getSingleResourcePropertyValue(resource, resourcePropertyName);
            Date date = DatePropertyConvertor.deserialize((Node[])resourcePropertyValue.getNodes());
            return date;
        }
        catch (ResourcePropertyValueParseException resourcePropertyValueParseException) {
            throw new ResourcePropertyParseException(resourcePropertyName, resourcePropertyValueParseException);
        }
    }

    public static Date getResourcePropertyAsNullableDate(Resource resource, ResourcePropertyName resourcePropertyName) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException {
        try {
            ResourcePropertyValue resourcePropertyValue = ResourcePropertyUtilities.getSingleResourcePropertyValue(resource, resourcePropertyName);
            Date date = NullableDatePropertyConvertor.deserialize((Node[])resourcePropertyValue.getNodes());
            return date;
        }
        catch (ResourcePropertyValueParseException resourcePropertyValueParseException) {
            throw new ResourcePropertyParseException(resourcePropertyName, resourcePropertyValueParseException);
        }
    }

    private static ResourcePropertyValue getSingleResourcePropertyValue(Resource resource, ResourcePropertyName resourcePropertyName) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException {
        try {
            ResourceProperty resourceProperty = resource.getResourceProperty(resourcePropertyName);
            ResourcePropertyValue[] resourcePropertyValueArray = resourceProperty.getValues();
            if (resourcePropertyValueArray.length == 1) {
                return resourcePropertyValueArray[0];
            }
            throw new ResourcePropertyParseException(resourcePropertyName, (Throwable)((Object)new ResourcePropertyValueCountException(1, 1, resourcePropertyValueArray.length)));
        }
        catch (PropertyNameInvalidException propertyNameInvalidException) {
            throw new UnsupportedPropertyTypeException(propertyNameInvalidException.getResourcePropertyName());
        }
    }
}

