/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.resource;

import java.util.Date;
import org.w3c.dom.Node;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.ResourceProperty;
import uk.org.ogsadai.client.toolkit.ResourcePropertyValue;
import uk.org.ogsadai.client.toolkit.TerminationTime;
import uk.org.ogsadai.client.toolkit.exception.ClientServerCompatibilityException;
import uk.org.ogsadai.client.toolkit.exception.ClientToolkitException;
import uk.org.ogsadai.client.toolkit.exception.PropertyNameInvalidException;
import uk.org.ogsadai.client.toolkit.exception.ResourceNotDestroyedException;
import uk.org.ogsadai.client.toolkit.exception.ResourcePropertyParseException;
import uk.org.ogsadai.client.toolkit.exception.ResourcePropertyValueCountException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerCommsException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.exception.TerminationTimeChangeRejectedException;
import uk.org.ogsadai.client.toolkit.exception.UnableToSetTerminationTimeException;
import uk.org.ogsadai.client.toolkit.resource.ResourcePropertyUtilities;
import uk.org.ogsadai.exception.ResourcePropertyValueParseException;
import uk.org.ogsadai.resource.ResourceID;
import uk.org.ogsadai.resource.ResourcePropertyName;
import uk.org.ogsadai.resource.ResourcePropertyNames;
import uk.org.ogsadai.resource.ResourceType;
import uk.org.ogsadai.resource.property.ActivitiesMetaData;
import uk.org.ogsadai.resource.property.NullableDatePropertyConvertor;

public abstract class BaseResource
implements Resource {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private final ResourceID mResourceID;
    private final ResourceType mResourceType;

    public BaseResource(ResourceID resourceID, ResourceType resourceType) {
        this.mResourceID = resourceID;
        this.mResourceType = resourceType;
    }

    public ResourceType getResourceType() {
        return this.mResourceType;
    }

    public ResourceID getResourceID() {
        return this.mResourceID;
    }

    public Date getCurrentTime() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        return this.getTimeResourceProperty(ResourcePropertyNames.CURRENT_TIME);
    }

    public Date getTerminationTime() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        return this.getTimeResourceProperty(ResourcePropertyNames.TERMINATION_TIME);
    }

    public abstract ResourceProperty getResourceProperty(ResourcePropertyName var1) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, PropertyNameInvalidException;

    public abstract ResourceProperty[] getMultipleResourceProperties(ResourcePropertyName[] var1) throws ServerCommsException, ServerException, ClientServerCompatibilityException, ResourceUnknownException, PropertyNameInvalidException;

    public abstract void destroy() throws ServerCommsException, ServerException, ClientServerCompatibilityException, ResourceUnknownException, ResourceNotDestroyedException;

    public abstract TerminationTime setTerminationTime(Date var1) throws ServerCommsException, ServerException, ClientServerCompatibilityException, ResourceUnknownException, UnableToSetTerminationTimeException, TerminationTimeChangeRejectedException;

    public ActivitiesMetaData getActivityDetails() throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException, ClientToolkitException {
        return ResourcePropertyUtilities.getResourcePropertyAsActivitiesMetaData(this, ResourcePropertyNames.SUPPORTED_ACTIVITIES);
    }

    protected Date getTimeResourceProperty(ResourcePropertyName resourcePropertyName) throws ServerCommsException, ServerException, ResourceUnknownException, ClientServerCompatibilityException {
        try {
            ResourceProperty resourceProperty = this.getResourceProperty(resourcePropertyName);
            ResourcePropertyValue[] resourcePropertyValueArray = resourceProperty.getValues();
            if (resourcePropertyValueArray.length == 1) {
                return NullableDatePropertyConvertor.deserialize((Node[])resourcePropertyValueArray[0].getNodes());
            }
            throw new ResourcePropertyParseException(resourcePropertyName, (Throwable)((Object)new ResourcePropertyValueCountException(1, 1, resourcePropertyValueArray.length)));
        }
        catch (ResourcePropertyValueParseException resourcePropertyValueParseException) {
            throw new ResourcePropertyParseException(resourcePropertyName, resourcePropertyValueParseException);
        }
    }
}

