/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.resource;

import java.util.Iterator;
import uk.org.ogsadai.client.toolkit.DataSinkResource;
import uk.org.ogsadai.client.toolkit.DataStreamStatus;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.exception.ClientException;
import uk.org.ogsadai.client.toolkit.exception.ClientServerCompatibilityException;
import uk.org.ogsadai.client.toolkit.exception.ClientToolkitException;
import uk.org.ogsadai.client.toolkit.exception.IllegalDataSinkStatusException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerCommsException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.resource.ResourcePropertyUtilities;
import uk.org.ogsadai.client.toolkit.resource.ResourceWrapper;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.resource.ResourcePropertyNames;
import uk.org.ogsadai.resource.datasink.DataSinkStatus;

public abstract class BaseDataSinkResource
extends ResourceWrapper
implements DataSinkResource {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";

    public BaseDataSinkResource(Resource resource) {
        super(resource);
    }

    public void putValue(DataValue dataValue) throws ServerCommsException, ServerException, ResourceUnknownException, ClientException {
        this.putValue(dataValue, DataStreamStatus.OPEN);
    }

    public void putValues(DataValue[] dataValueArray) throws ServerCommsException, ServerException, ResourceUnknownException, ClientException {
        this.putValues(dataValueArray, DataStreamStatus.OPEN);
    }

    public void putValues(Iterator iterator) throws ServerCommsException, ServerException, ResourceUnknownException, ClientException {
        this.putValues(iterator, DataStreamStatus.OPEN);
    }

    public DataSinkStatus getStatus() throws ServerCommsException, ServerException, ResourceUnknownException, ClientException, ClientServerCompatibilityException, ClientToolkitException {
        try {
            String string = ResourcePropertyUtilities.getResourcePropertyAsString(this, ResourcePropertyNames.DATA_SINK_STATUS);
            return DataSinkStatus.getStatus((String)string);
        }
        catch (uk.org.ogsadai.resource.datasink.IllegalDataSinkStatusException illegalDataSinkStatusException) {
            throw new IllegalDataSinkStatusException(illegalDataSinkStatusException.getIllegalStateValue());
        }
    }
}

