/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.resource;

import uk.org.ogsadai.client.toolkit.DataRequestExecutionResource;
import uk.org.ogsadai.client.toolkit.DataSinkResource;
import uk.org.ogsadai.client.toolkit.DataSourceResource;
import uk.org.ogsadai.client.toolkit.NoSession;
import uk.org.ogsadai.client.toolkit.PipelineWorkflow;
import uk.org.ogsadai.client.toolkit.RequestExecutionType;
import uk.org.ogsadai.client.toolkit.RequestResource;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.SessionOperation;
import uk.org.ogsadai.client.toolkit.SessionResource;
import uk.org.ogsadai.client.toolkit.Workflow;
import uk.org.ogsadai.client.toolkit.activities.delivery.DeliverToRequestStatus;
import uk.org.ogsadai.client.toolkit.activities.management.CreateDataSink;
import uk.org.ogsadai.client.toolkit.activities.management.CreateDataSource;
import uk.org.ogsadai.client.toolkit.exception.ClientException;
import uk.org.ogsadai.client.toolkit.exception.ClientServerCompatibilityException;
import uk.org.ogsadai.client.toolkit.exception.ClientToolkitException;
import uk.org.ogsadai.client.toolkit.exception.RequestCompletedWithErrorException;
import uk.org.ogsadai.client.toolkit.exception.RequestErrorException;
import uk.org.ogsadai.client.toolkit.exception.RequestException;
import uk.org.ogsadai.client.toolkit.exception.RequestTerminatedException;
import uk.org.ogsadai.client.toolkit.exception.ResourceCreationException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerCommsException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.client.toolkit.resource.ResourceWrapper;
import uk.org.ogsadai.resource.ResourceID;
import uk.org.ogsadai.resource.drer.ExecutionResult;
import uk.org.ogsadai.resource.request.RequestExecutionStatus;
import uk.org.ogsadai.resource.request.RequestStatus;

public abstract class BaseDataRequestExecutionResource
extends ResourceWrapper
implements DataRequestExecutionResource {
    private static final String COPYRIGHT_NOTICE = "Copyright (C) The University of Edinburgh, 2007.";
    private final Server mServer;

    public BaseDataRequestExecutionResource(Resource resource, Server server) {
        super(resource);
        this.mServer = server;
    }

    public RequestResource execute(ResourceID resourceID, Workflow workflow, RequestExecutionType requestExecutionType) throws ServerCommsException, ServerException, ResourceUnknownException, RequestException, ClientException, ClientToolkitException {
        return this.execute(resourceID, workflow, requestExecutionType, NoSession.getInstance());
    }

    public RequestResource execute(Workflow workflow, RequestExecutionType requestExecutionType) throws ServerCommsException, ServerException, ResourceUnknownException, RequestException, ClientException, ClientToolkitException {
        return this.execute(null, workflow, requestExecutionType, NoSession.getInstance());
    }

    public RequestResource execute(ResourceID resourceID, Workflow workflow, RequestExecutionType requestExecutionType, SessionOperation sessionOperation) throws ServerCommsException, ServerException, ResourceUnknownException, RequestException, ClientException, ClientToolkitException {
        ExecutionResult executionResult = this.executeRequest(resourceID, workflow, requestExecutionType, sessionOperation);
        workflow.getRequestAndStatusHandler().setServer(this.mServer);
        RequestResource requestResource = this.mServer.getRequestResource(executionResult.getRequestID());
        ResourceID resourceID2 = executionResult.getSessionID();
        if (resourceID2 != null) {
            SessionResource sessionResource = this.mServer.getSessionResource(resourceID2);
            requestResource.setSessionResource(sessionResource);
        }
        requestResource.setRequestWorkflow(workflow);
        requestResource.setRequestStatus(executionResult.getRequestStatus());
        this.checkSynchronousExecutionIsComplete(requestResource, executionResult);
        return requestResource;
    }

    public RequestResource execute(Workflow workflow, RequestExecutionType requestExecutionType, SessionOperation sessionOperation) throws ServerCommsException, ServerException, ResourceUnknownException, RequestException, ClientException, ClientToolkitException {
        return this.execute(null, workflow, requestExecutionType, sessionOperation);
    }

    public DataSinkResource createDataSinkResource() throws ServerCommsException, ServerException, ResourceUnknownException, ClientException, RequestException, ClientToolkitException, ClientServerCompatibilityException {
        CreateDataSink createDataSink = new CreateDataSink();
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(createDataSink.getResultOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(createDataSink);
        pipelineWorkflow.add(deliverToRequestStatus);
        this.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        try {
            ResourceID resourceID = createDataSink.nextResult();
            return this.mServer.getDataSinkResource(resourceID);
        }
        catch (Exception exception) {
            throw new ResourceCreationException(exception);
        }
    }

    public DataSourceResource createDataSourceResource() throws ServerCommsException, ServerException, ResourceUnknownException, ClientException, RequestException, ClientToolkitException, ClientServerCompatibilityException {
        CreateDataSource createDataSource = new CreateDataSource();
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(createDataSource.getResultOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(createDataSource);
        pipelineWorkflow.add(deliverToRequestStatus);
        this.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        try {
            ResourceID resourceID = createDataSource.nextResult();
            return this.mServer.getDataSourceResource(resourceID);
        }
        catch (Exception exception) {
            throw new ResourceCreationException(exception);
        }
    }

    protected Server getServer() {
        return this.mServer;
    }

    protected abstract ExecutionResult executeRequest(ResourceID var1, Workflow var2, RequestExecutionType var3, SessionOperation var4) throws ServerCommsException, ServerException, ResourceUnknownException, RequestException, ClientException, ClientToolkitException;

    private void checkSynchronousExecutionIsComplete(RequestResource requestResource, ExecutionResult executionResult) throws RequestErrorException, RequestCompletedWithErrorException, RequestTerminatedException {
        RequestStatus requestStatus = executionResult.getRequestStatus();
        RequestExecutionStatus requestExecutionStatus = requestStatus.getExecutionStatus();
        if (requestExecutionStatus == RequestExecutionStatus.ERROR) {
            RequestErrorException requestErrorException = new RequestErrorException(requestResource, requestStatus);
            throw requestErrorException;
        }
        if (requestExecutionStatus == RequestExecutionStatus.COMPLETED_WITH_ERROR) {
            throw new RequestCompletedWithErrorException(requestResource);
        }
        if (requestExecutionStatus == RequestExecutionStatus.TERMINATED) {
            throw new RequestTerminatedException(requestResource);
        }
    }
}

