/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.property.convertor;

import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import uk.org.ogsadai.activity.ActivityInstanceName;
import uk.org.ogsadai.activity.RequestStatusBuilder;
import uk.org.ogsadai.client.toolkit.exception.ClientServerCompatibilityException;
import uk.org.ogsadai.client.toolkit.exception.DataValueParseException;
import uk.org.ogsadai.client.toolkit.exception.DataValueUnknownTypeException;
import uk.org.ogsadai.common.Base64;
import uk.org.ogsadai.resource.property.DatePropertyConvertor;

public class XMLDataValueFactory {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private final Map mDataMapper = new HashMap();
    final RequestStatusBuilder mBuilder;

    public XMLDataValueFactory(RequestStatusBuilder requestStatusBuilder) {
        this.mBuilder = requestStatusBuilder;
        this.mDataMapper.put("binary", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, Base64.decode((String)string2));
            }
        });
        this.mDataMapper.put("string", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, string2);
            }
        });
        this.mDataMapper.put("charArray", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, string2.toCharArray());
            }
        });
        this.mDataMapper.put("long", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, Long.parseLong(string2));
            }
        });
        this.mDataMapper.put("int", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, Integer.parseInt(string2));
            }
        });
        this.mDataMapper.put("float", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, Float.parseFloat(string2));
            }
        });
        this.mDataMapper.put("double", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, Double.parseDouble(string2));
            }
        });
        this.mDataMapper.put("date", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) throws ParseException {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, DatePropertyConvertor.parseXSDDate((String)string2));
            }
        });
        this.mDataMapper.put("boolean", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addData(activityInstanceName, string, Boolean.valueOf(string2).booleanValue());
            }
        });
        this.mDataMapper.put("listBegin", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addListBegin(activityInstanceName, string);
            }
        });
        this.mDataMapper.put("listEnd", new DataConverter(){

            public void addData(ActivityInstanceName activityInstanceName, String string, String string2) {
                XMLDataValueFactory.this.mBuilder.addListEnd(activityInstanceName, string);
            }
        });
    }

    public void addData(ActivityInstanceName activityInstanceName, String string, String string2, String string3) throws ClientServerCompatibilityException {
        DataConverter dataConverter = (DataConverter)this.mDataMapper.get(string2);
        if (dataConverter != null) {
            try {
                dataConverter.addData(activityInstanceName, string, string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new DataValueParseException(string2, string3, numberFormatException);
            }
            catch (ParseException parseException) {
                throw new DataValueParseException(string2, string3, parseException);
            }
        } else {
            throw new DataValueUnknownTypeException(string2);
        }
    }

    private static interface DataConverter {
        public void addData(ActivityInstanceName var1, String var2, String var3) throws NumberFormatException, ParseException;
    }
}

