/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.property.convertor;

import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import uk.org.ogsadai.activity.ActivityInstanceName;
import uk.org.ogsadai.activity.ActivityStatus;
import uk.org.ogsadai.activity.RequestStatusBuilder;
import uk.org.ogsadai.activity.event.SimpleWarning;
import uk.org.ogsadai.activity.event.Warning;
import uk.org.ogsadai.activity.request.status.SimpleRequestStatusBuilder;
import uk.org.ogsadai.client.toolkit.exception.ClientServerCompatibilityException;
import uk.org.ogsadai.client.toolkit.property.convertor.ClientToolkitDAIException;
import uk.org.ogsadai.client.toolkit.property.convertor.RequestExecutionStatusXMLConvertor;
import uk.org.ogsadai.client.toolkit.property.convertor.XMLDataValueFactory;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.exception.ErrorID;
import uk.org.ogsadai.resource.request.RequestStatus;
import uk.org.ogsadai.util.xml.XML;

public class RequestStatusXMLConvertor {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";

    public static RequestStatus convert(Element element) throws ClientServerCompatibilityException {
        Object object;
        Object object2;
        Object object3;
        if (element == null) {
            throw new IllegalArgumentException("Property value must not be null");
        }
        NodeList nodeList = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "requestDetails");
        Element element2 = (Element)nodeList.item(0);
        String string = element2.getAttribute("id");
        String string2 = element2.getAttribute("status");
        SimpleRequestStatusBuilder simpleRequestStatusBuilder = new SimpleRequestStatusBuilder(string);
        simpleRequestStatusBuilder.setExecutionStatus(RequestExecutionStatusXMLConvertor.getExecutionStatus(string2));
        DAIException dAIException = RequestStatusXMLConvertor.getError(element2.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "error"));
        simpleRequestStatusBuilder.setRequestError(dAIException);
        NodeList nodeList2 = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "activity");
        for (int i = 0; i < nodeList2.getLength(); ++i) {
            object3 = (Element)nodeList2.item(i);
            String string3 = object3.getAttribute("instanceName");
            object2 = new ActivityInstanceName(string3);
            object = RequestStatusXMLConvertor.getActivityStatus(object3.getAttribute("status"));
            simpleRequestStatusBuilder.setActivityStatus((ActivityInstanceName)object2, object);
            dAIException = RequestStatusXMLConvertor.getError(object3.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "error"));
            simpleRequestStatusBuilder.buildActivityError((ActivityInstanceName)object2, dAIException);
            RequestStatusXMLConvertor.handleWarnings((ActivityInstanceName)object2, (RequestStatusBuilder)simpleRequestStatusBuilder, object3.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "warning"));
        }
        NodeList nodeList3 = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "result");
        object3 = new XMLDataValueFactory((RequestStatusBuilder)simpleRequestStatusBuilder);
        for (int i = 0; i < nodeList3.getLength(); ++i) {
            object2 = (Element)nodeList3.item(i);
            object = object2.getAttribute("activityInstanceName");
            ActivityInstanceName activityInstanceName = new ActivityInstanceName((String)object);
            String string4 = object2.getAttribute("resultName");
            NodeList nodeList4 = object2.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "data");
            for (int j = 0; j < nodeList4.getLength(); ++j) {
                List list = XML.getChildElements((Element)((Element)nodeList4.item(j)));
                Element element3 = (Element)list.iterator().next();
                RequestStatusXMLConvertor.handleData(activityInstanceName, string4, (XMLDataValueFactory)object3, element3);
            }
        }
        return simpleRequestStatusBuilder.getRequestStatus();
    }

    private static ActivityStatus getActivityStatus(String string) {
        if (ActivityStatus.COMPLETED.toString().equals(string)) {
            return ActivityStatus.COMPLETED;
        }
        if (ActivityStatus.ERROR.toString().equals(string)) {
            return ActivityStatus.ERROR;
        }
        if (ActivityStatus.INITIALISING.toString().equals(string)) {
            return ActivityStatus.INITIALISING;
        }
        if (ActivityStatus.PROCESSING.toString().equals(string)) {
            return ActivityStatus.PROCESSING;
        }
        if (ActivityStatus.TERMINATED.toString().equals(string)) {
            return ActivityStatus.TERMINATED;
        }
        if (ActivityStatus.UNSTARTED.toString().equals(string)) {
            return ActivityStatus.UNSTARTED;
        }
        return ActivityStatus.ERROR;
    }

    private static void handleData(ActivityInstanceName activityInstanceName, String string, XMLDataValueFactory xMLDataValueFactory, Element element) throws ClientServerCompatibilityException {
        String string2 = element.getLocalName();
        String string3 = null;
        if (element.getFirstChild() != null) {
            string3 = element.getFirstChild().getNodeValue();
        }
        xMLDataValueFactory.addData(activityInstanceName, string, string2, string3);
    }

    private static DAIException getError(NodeList nodeList) {
        ClientToolkitDAIException clientToolkitDAIException = null;
        if (nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            NodeList nodeList2 = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "errorCause");
            ClientToolkitDAIException clientToolkitDAIException2 = null;
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Element element2 = (Element)nodeList2.item(i);
                String string = XML.getText((Element)element2, (String)"id");
                NodeList nodeList3 = element2.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "parameter");
                Object[] objectArray = new String[nodeList3.getLength()];
                for (int j = 0; j < nodeList3.getLength(); ++j) {
                    Element element3 = (Element)nodeList3.item(j);
                    objectArray[j] = element3.getFirstChild().getNodeValue();
                }
                ClientToolkitDAIException clientToolkitDAIException3 = new ClientToolkitDAIException();
                clientToolkitDAIException3.setErrorID(new ErrorID(string));
                clientToolkitDAIException3.setParameters(objectArray);
                if (clientToolkitDAIException2 != null) {
                    clientToolkitDAIException2.initCause((Throwable)((Object)clientToolkitDAIException3));
                } else {
                    clientToolkitDAIException = clientToolkitDAIException3;
                }
                clientToolkitDAIException2 = clientToolkitDAIException3;
            }
        }
        return clientToolkitDAIException;
    }

    private static void handleWarnings(ActivityInstanceName activityInstanceName, RequestStatusBuilder requestStatusBuilder, NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = XML.getText((Element)element, (String)"id");
            NodeList nodeList2 = element.getElementsByTagNameNS("http://ogsadai.org.uk/namespaces/2007/04/types", "parameter");
            Object[] objectArray = new String[nodeList2.getLength()];
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                Element element2 = (Element)nodeList2.item(j);
                objectArray[j] = element2.getFirstChild().getNodeValue();
            }
            SimpleWarning simpleWarning = new SimpleWarning(new MessageID(string), objectArray);
            requestStatusBuilder.buildActivityWarning(activityInstanceName, (Warning)simpleWarning);
        }
    }
}

