/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.messages;

import java.util.ArrayList;
import uk.org.ogsadai.common.msgs.MessageID;
import uk.org.ogsadai.common.msgs.MessageLoader;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.exception.ErrorID;

public class Message {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007.";
    private final String mMessageID;
    private final String[] mParameters;

    public Message(String string, String[] stringArray) {
        this.mMessageID = string;
        this.mParameters = stringArray;
    }

    public String getID() {
        return this.mMessageID;
    }

    public String[] getParameters() {
        return this.mParameters;
    }

    public String toString() {
        return MessageLoader.getLocalizedMessage((MessageID)new MessageID(this.mMessageID), (Object[])this.mParameters);
    }

    public static Message[] buildMessageArrayFromDAIException(DAIException dAIException) {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        for (Throwable throwable = dAIException; throwable != null; throwable = throwable.getCause()) {
            Message message;
            if (throwable instanceof DAIException) {
                DAIException dAIException2 = throwable;
                Object[] objectArray = dAIException2.getParameters();
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    stringArray[i] = object != null ? objectArray[i].toString() : "null";
                }
                message = new Message(dAIException2.getErrorID().toString(), stringArray);
            } else {
                message = new Message(ErrorID.NON_OGSA_DAI_COMPLIANT_ERROR.toString(), new String[]{throwable.getClass().getName(), throwable.getMessage()});
            }
            arrayList.add(message);
        }
        return arrayList.toArray(new Message[0]);
    }
}

