/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.exception;

import uk.org.ogsadai.client.toolkit.exception.DataException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.exception.ErrorID;

public class UnexpectedDataValueException
extends DataException {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private Class[] mExpectedDataValueClasses;
    private DataValue mActualDataValue;

    public UnexpectedDataValueException(DataValue dataValue) {
        super(ErrorID.CTK_UNEXPECTED_DATA_VALUE_WITH_NO_EXPECTED_CLASSES_ERROR, new Object[]{dataValue, dataValue.getClass().getName()});
        this.mExpectedDataValueClasses = new Class[0];
        this.mActualDataValue = dataValue;
    }

    public UnexpectedDataValueException(Class clazz, DataValue dataValue) {
        this(new Class[]{clazz}, dataValue);
    }

    public UnexpectedDataValueException(Class[] classArray, DataValue dataValue) {
        super(ErrorID.CTK_UNEXPECTED_DATA_VALUE_ERROR, new Object[]{dataValue.toString(), dataValue.getClass().getClass(), UnexpectedDataValueException.buildClassNameString(classArray)});
        this.mExpectedDataValueClasses = classArray;
        this.mActualDataValue = dataValue;
    }

    public Class[] getExpectedDataValueClasses() {
        return this.mExpectedDataValueClasses;
    }

    public DataValue getActualDataValue() {
        return this.mActualDataValue;
    }

    private static String buildClassNameString(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < classArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(classArray[i].getName());
        }
        return stringBuffer.toString();
    }
}

