/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.exception;

import uk.org.ogsadai.client.toolkit.RequestResource;
import uk.org.ogsadai.client.toolkit.exception.RequestExecutionException;
import uk.org.ogsadai.client.toolkit.exception.ServerMessageException;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.exception.ErrorID;
import uk.org.ogsadai.resource.request.RequestStatus;

public class RequestErrorException
extends RequestExecutionException {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007.";

    public RequestErrorException(RequestResource requestResource, RequestStatus requestStatus) {
        super(requestResource, ErrorID.CTK_REQUEST_ERROR, new Object[]{requestResource.getResourceID().toString()});
        DAIException dAIException = requestStatus.getError();
        if (dAIException != null) {
            this.setCause(dAIException);
        }
    }

    private void setCause(DAIException dAIException) {
        Throwable throwable = this;
        Throwable throwable2 = dAIException;
        while (throwable2 != null) {
            Throwable throwable3;
            if (throwable2 instanceof DAIException) {
                throwable3 = throwable2;
                ServerMessageException serverMessageException = new ServerMessageException(throwable3.getErrorID().toString(), this.convertObjectArrayToStringArray(throwable3.getParameters()));
                throwable.initCause((Throwable)((Object)serverMessageException));
                throwable = serverMessageException;
            } else {
                throwable3 = new ServerMessageException(ErrorID.NON_OGSA_DAI_COMPLIANT_ERROR.toString(), new String[]{throwable2.getClass().getName(), throwable2.getMessage()});
                throwable.initCause(throwable3);
                throwable = throwable3;
            }
            throwable3 = throwable2.getCause();
            throwable2 = null;
            if (throwable3 == null) continue;
            throwable2 = throwable3;
        }
    }

    private String[] convertObjectArrayToStringArray(Object[] objectArray) {
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = objectArray[i].toString();
        }
        return stringArray;
    }
}

