/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.example;

import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import uk.org.ogsadai.client.toolkit.DataIterator;
import uk.org.ogsadai.client.toolkit.DataRequestExecutionResource;
import uk.org.ogsadai.client.toolkit.PipelineWorkflow;
import uk.org.ogsadai.client.toolkit.RequestExecutionType;
import uk.org.ogsadai.client.toolkit.RequestResource;
import uk.org.ogsadai.client.toolkit.ServerProxy;
import uk.org.ogsadai.client.toolkit.activities.delivery.DeliverToRequestStatus;
import uk.org.ogsadai.client.toolkit.activities.xmldb.XMLListCollections;
import uk.org.ogsadai.client.toolkit.activities.xmldb.XMLListResources;
import uk.org.ogsadai.client.toolkit.activities.xmldb.XPathQuery;
import uk.org.ogsadai.client.toolkit.example.ClientBase;
import uk.org.ogsadai.resource.ResourceID;

public class XMLDBClient
extends ClientBase {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final String LIST_COLLECTIONS = "listCollections";
    private static final String LIST_RESOURCES = "listResources";
    private static final String XPATH_QUERY = "xpath";
    private static final String URL = "u";
    private static final String DRER = "e";
    private static final String DATA_RESOURCE = "d";
    private static final String COMMAND = "c";
    private static final String COLLECTION = "coll";
    private static final String RESOURCE = "r";
    private static final String XPATH = "x";
    private static final String NAMESPACE = "n";

    public static void main(String[] stringArray) throws Exception {
        XMLDBClient xMLDBClient = new XMLDBClient();
        xMLDBClient.execute(stringArray);
    }

    public void execute(String[] stringArray) throws Exception {
        String string;
        Hashtable hashtable = new Hashtable();
        super.parseArguments(stringArray, hashtable);
        String string2 = super.getSingleValueOptionalFlag(hashtable, URL);
        if (string2 == null) {
            string2 = "http://localhost:8080/dai/services/";
        }
        if ((string = super.getSingleValueOptionalFlag(hashtable, DRER)) == null) {
            string = "DataRequestExecutionResource";
        }
        ResourceID resourceID = new ResourceID(string);
        String string3 = super.getSingleValueOptionalFlag(hashtable, DATA_RESOURCE);
        if (string3 == null) {
            string3 = "XMLDBResource";
        }
        ResourceID resourceID2 = new ResourceID(string3);
        String string4 = super.getSingleValue(hashtable, COMMAND);
        String string5 = null;
        String string6 = null;
        String string7 = null;
        List list = null;
        if (string4.equals(LIST_COLLECTIONS)) {
            string5 = this.getSingleValueOptionalFlag(hashtable, COLLECTION);
        } else if (string4.equals(LIST_RESOURCES)) {
            string5 = this.getSingleValueOptionalFlag(hashtable, COLLECTION);
        } else if (string4.equals(XPATH_QUERY)) {
            string5 = this.getSingleValueOptionalFlag(hashtable, COLLECTION);
            string6 = this.getSingleValueOptionalFlag(hashtable, RESOURCE);
            list = this.getValuesOptionalFlag(hashtable, NAMESPACE);
            string7 = this.getSingleValue(hashtable, XPATH);
        } else {
            throw new IllegalArgumentException("value for flag -c must be one of: listCollections, listResources or xpath");
        }
        System.out.println("DRER ID: " + resourceID);
        System.out.println("Data Resource ID: " + resourceID2);
        System.out.println("Base Services URL: " + string2);
        System.out.println("Command: " + string4);
        if (string5 != null) {
            System.out.println("Collection: " + string5);
        }
        if (string6 != null) {
            System.out.println("Resource: " + string6);
        }
        if (string7 != null) {
            System.out.println("XPath: " + string7);
        }
        System.out.println("DRER ID: " + resourceID);
        System.out.println("Data Resource ID: " + resourceID2);
        System.out.println("Base Services URL: " + string2);
        System.out.println("Command: " + string4);
        if (string5 != null) {
            System.out.println("Collection: " + string5);
        }
        if (string6 != null) {
            System.out.println("Resource: " + string6);
        }
        if (string7 != null) {
            System.out.println("XPath: " + string7);
        }
        ServerProxy serverProxy = new ServerProxy();
        serverProxy.setDefaultBaseServicesURL(new URL(string2));
        DataRequestExecutionResource dataRequestExecutionResource = serverProxy.getDataRequestExecutionResource(resourceID);
        if (string4.equals(LIST_COLLECTIONS)) {
            XMLDBClient.listCollections(dataRequestExecutionResource, resourceID2, string5);
        } else if (string4.equals(LIST_RESOURCES)) {
            XMLDBClient.listResources(dataRequestExecutionResource, resourceID2, string5);
        } else if (string4.equals(XPATH_QUERY)) {
            XMLDBClient.xpathQuery(dataRequestExecutionResource, resourceID2, string5, string6, list, string7);
        }
    }

    private static void listCollections(DataRequestExecutionResource dataRequestExecutionResource, ResourceID resourceID, String string) throws Exception {
        Object object;
        XMLListCollections xMLListCollections = new XMLListCollections();
        xMLListCollections.setResourceID(resourceID);
        if (string != null) {
            xMLListCollections.addParentCollection(string);
        }
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(xMLListCollections.getDataOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(xMLListCollections);
        pipelineWorkflow.add(deliverToRequestStatus);
        RequestResource requestResource = null;
        try {
            requestResource = dataRequestExecutionResource.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        }
        catch (Throwable throwable) {
            System.out.println("A problem has occured...");
            while (object != null) {
                System.out.println(object.getMessage());
                object = object.getCause();
            }
            System.exit(1);
        }
        object = requestResource.getRequestStatus();
        System.out.println(object.getExecutionStatus());
        while (xMLListCollections.hasNextData()) {
            DataIterator dataIterator = xMLListCollections.nextData();
            while (dataIterator.hasNext()) {
                System.out.println(dataIterator.next());
            }
        }
    }

    private static void listResources(DataRequestExecutionResource dataRequestExecutionResource, ResourceID resourceID, String string) throws Exception {
        Object object;
        XMLListResources xMLListResources = new XMLListResources();
        xMLListResources.setResourceID(resourceID);
        if (string != null) {
            xMLListResources.addParentCollection(string);
        }
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(xMLListResources.getDataOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(xMLListResources);
        pipelineWorkflow.add(deliverToRequestStatus);
        RequestResource requestResource = null;
        try {
            requestResource = dataRequestExecutionResource.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        }
        catch (Throwable throwable) {
            System.out.println("A problem has occured...");
            while (object != null) {
                System.out.println(object.getMessage());
                object = object.getCause();
            }
            System.exit(1);
        }
        object = requestResource.getRequestStatus();
        System.out.println(object.getExecutionStatus());
        while (xMLListResources.hasNextData()) {
            DataIterator dataIterator = xMLListResources.nextData();
            while (dataIterator.hasNext()) {
                System.out.println(dataIterator.next());
            }
        }
    }

    private static void xpathQuery(DataRequestExecutionResource dataRequestExecutionResource, ResourceID resourceID, String string, String string2, List list, String string3) throws Exception {
        Object object;
        XPathQuery xPathQuery = new XPathQuery();
        xPathQuery.setResourceID(resourceID);
        if (string != null) {
            xPathQuery.addCollection(string);
        }
        if (string2 != null) {
            xPathQuery.addResourceID(string2);
        }
        xPathQuery.addExpression(string3);
        if (list != null) {
            xPathQuery.addNamespace(list.iterator());
        }
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(xPathQuery.getDataOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(xPathQuery);
        pipelineWorkflow.add(deliverToRequestStatus);
        RequestResource requestResource = null;
        try {
            requestResource = dataRequestExecutionResource.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        }
        catch (Throwable throwable) {
            System.out.println("A problem has occured...");
            while (object != null) {
                System.out.println(object.getMessage());
                object = object.getCause();
            }
            System.exit(1);
        }
        object = requestResource.getRequestStatus();
        System.out.println(object.getExecutionStatus());
        while (xPathQuery.hasNextResult()) {
            Reader reader = xPathQuery.getNextResult();
            BufferedReader bufferedReader = new BufferedReader(reader);
            String string4 = null;
            while ((string4 = bufferedReader.readLine()) != null) {
                System.out.println(string4);
            }
        }
    }
}

