/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.example;

import java.net.URL;
import java.util.Hashtable;
import uk.org.ogsadai.activity.ActivityContractName;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.ResourceProperty;
import uk.org.ogsadai.client.toolkit.ServerProxy;
import uk.org.ogsadai.client.toolkit.example.ClientBase;
import uk.org.ogsadai.resource.ResourceID;
import uk.org.ogsadai.resource.ResourcePropertyName;
import uk.org.ogsadai.resource.ResourceType;
import uk.org.ogsadai.resource.property.ActivitiesMetaData;
import uk.org.ogsadai.resource.property.ActivityMetaData;

public class ServerClient
extends ClientBase {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final String GET_VERSION = "getVersion";
    private static final String LIST_RESOURCES = "listResources";
    private static final String GET_LIFETIME = "getLifetime";
    private static final String GET_PROPERTY = "getProperty";
    private static final String GET_ACTIVITIES = "getActivities";
    private static final String RESOLVE = "resolve";
    private static final String URL = "u";
    private static final String COMMAND = "c";
    private static final String TYPE = "t";
    private static final String ID = "r";
    private static final String PROPERTY = "p";

    public static void main(String[] stringArray) throws Exception {
        ServerClient serverClient = new ServerClient();
        serverClient.execute(stringArray);
    }

    public void execute(String[] stringArray) throws Exception {
        Hashtable hashtable = new Hashtable();
        super.parseArguments(stringArray, hashtable);
        String string = super.getSingleValueOptionalFlag(hashtable, URL);
        if (string == null) {
            string = "http://localhost:8080/dai/services/";
        }
        String string2 = super.getSingleValue(hashtable, COMMAND);
        String string3 = null;
        String string4 = null;
        String string5 = null;
        if (string2.equals(LIST_RESOURCES)) {
            string3 = super.getSingleValueOptionalFlag(hashtable, TYPE);
        } else if (string2.equals(GET_LIFETIME)) {
            string3 = super.getSingleValue(hashtable, TYPE);
            string4 = super.getSingleValue(hashtable, ID);
        } else if (string2.equals(GET_ACTIVITIES)) {
            string3 = super.getSingleValue(hashtable, TYPE);
            string4 = super.getSingleValue(hashtable, ID);
        } else if (string2.equals(GET_PROPERTY)) {
            string3 = super.getSingleValue(hashtable, TYPE);
            string4 = super.getSingleValue(hashtable, ID);
            string5 = super.getSingleValue(hashtable, PROPERTY);
        } else if (string2.equals(RESOLVE)) {
            string3 = super.getSingleValue(hashtable, TYPE);
            string4 = super.getSingleValue(hashtable, ID);
        } else if (!string2.equals(GET_VERSION)) {
            throw new IllegalArgumentException("value for flag -c must be one of: listResources, getLifetime or getProperty");
        }
        ResourceID resourceID = null;
        if (string4 != null) {
            resourceID = new ResourceID(string4);
        }
        ResourceType resourceType = null;
        if (string3 != null) {
            resourceType = ResourceType.getResourceType((String)string3);
        }
        ResourcePropertyName resourcePropertyName = null;
        if (string5 != null) {
            resourcePropertyName = new ResourcePropertyName(string5);
        }
        ServerProxy serverProxy = new ServerProxy();
        serverProxy.setDefaultBaseServicesURL(new URL(string));
        if (string2.equals(GET_VERSION)) {
            System.out.println(serverProxy.getVersion(ResourceType.DATA_REQUEST_EXECUTION_RESOURCE));
        } else if (string2.equals(LIST_RESOURCES)) {
            if (resourceType == null) {
                this.listResources(serverProxy, ResourceType.DATA_REQUEST_EXECUTION_RESOURCE);
                this.listResources(serverProxy, ResourceType.DATA_RESOURCE);
                this.listResources(serverProxy, ResourceType.SESSION);
                this.listResources(serverProxy, ResourceType.REQUEST);
                this.listResources(serverProxy, ResourceType.DATA_SOURCE);
                this.listResources(serverProxy, ResourceType.DATA_SINK);
            } else {
                this.listResources(serverProxy, resourceType);
            }
        } else if (string2.equals(GET_LIFETIME)) {
            Resource resource = serverProxy.getResource(resourceID, resourceType);
            System.out.println("Current time: " + resource.getCurrentTime());
            System.out.println("Termination time: " + resource.getTerminationTime());
        } else if (string2.equals(GET_ACTIVITIES)) {
            Resource resource = serverProxy.getResource(resourceID, resourceType);
            ActivitiesMetaData activitiesMetaData = resource.getActivityDetails();
            ActivityMetaData[] activityMetaDataArray = activitiesMetaData.getActivityMetaData();
            for (int i = 0; i < activityMetaDataArray.length; ++i) {
                ActivityMetaData activityMetaData = activityMetaDataArray[i];
                System.out.println(activityMetaData.getActivityName() + "   " + activityMetaData.getDescription());
                ActivityContractName[] activityContractNameArray = activityMetaData.getActivityContracts();
                System.out.println("Number of activity contracts: " + activityContractNameArray.length);
                for (int j = 0; j < activityContractNameArray.length; ++j) {
                    System.out.println(" " + activityContractNameArray[j]);
                }
            }
        } else if (string2.equals(RESOLVE)) {
            System.out.println(serverProxy.resolve(resourceID, resourceType));
        } else if (string2.equals(GET_PROPERTY)) {
            Resource resource = serverProxy.getResource(resourceID, resourceType);
            ResourceProperty resourceProperty = resource.getResourceProperty(resourcePropertyName);
            System.out.println(resourceProperty);
        }
    }

    private void listResources(ServerProxy serverProxy, ResourceType resourceType) throws Exception {
        ResourceID[] resourceIDArray = serverProxy.listResources(resourceType);
        System.out.println("Number of resources: " + resourceIDArray.length);
        for (int i = 0; i < resourceIDArray.length; ++i) {
            System.out.println(resourceIDArray[i]);
        }
    }
}

