/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.example;

import java.net.URL;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import uk.org.ogsadai.client.toolkit.DataRequestExecutionResource;
import uk.org.ogsadai.client.toolkit.PipelineWorkflow;
import uk.org.ogsadai.client.toolkit.RequestExecutionType;
import uk.org.ogsadai.client.toolkit.RequestResource;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.ServerProxy;
import uk.org.ogsadai.client.toolkit.activities.block.CharArraysResize;
import uk.org.ogsadai.client.toolkit.activities.delivery.DeliverToRequestStatus;
import uk.org.ogsadai.client.toolkit.activities.sql.SQLQuery;
import uk.org.ogsadai.client.toolkit.activities.transform.TupleToWebRowSetCharArrays;
import uk.org.ogsadai.client.toolkit.example.ClientBase;
import uk.org.ogsadai.resource.ResourceID;

public class SQLClient
extends ClientBase {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final String URL = "u";
    private static final String DRER = "e";
    private static final String DATA_RESOURCE = "d";
    private static final String QUERY = "q";
    private ResourceID mDrerID;
    private ResourceID mDataResourceID;
    private String mURL;
    private String mSQLQuery;

    public static void main(String[] stringArray) throws Exception {
        SQLClient sQLClient = new SQLClient();
        sQLClient.execute(stringArray);
    }

    public void execute(String[] stringArray) throws Exception {
        Object object;
        Hashtable hashtable = new Hashtable();
        super.parseArguments(stringArray, hashtable);
        this.processParameters(hashtable);
        this.printArguments();
        ServerProxy serverProxy = new ServerProxy();
        serverProxy.setDefaultBaseServicesURL(new URL(this.mURL));
        DataRequestExecutionResource dataRequestExecutionResource = serverProxy.getDataRequestExecutionResource(this.mDrerID);
        this.applySecurityToResource(dataRequestExecutionResource);
        SQLQuery sQLQuery = new SQLQuery();
        sQLQuery.setResourceID(this.mDataResourceID);
        sQLQuery.addExpression(this.mSQLQuery);
        TupleToWebRowSetCharArrays tupleToWebRowSetCharArrays = new TupleToWebRowSetCharArrays();
        tupleToWebRowSetCharArrays.connectDataInput(sQLQuery.getDataOutput());
        CharArraysResize charArraysResize = new CharArraysResize();
        charArraysResize.addArraySizeInput(5000);
        charArraysResize.connectDataInput(tupleToWebRowSetCharArrays.getResultOutput());
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(charArraysResize.getOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(sQLQuery);
        pipelineWorkflow.add(tupleToWebRowSetCharArrays);
        pipelineWorkflow.add(charArraysResize);
        pipelineWorkflow.add(deliverToRequestStatus);
        RequestResource requestResource = null;
        try {
            requestResource = dataRequestExecutionResource.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        }
        catch (Throwable throwable) {
            System.out.println("A problem has occured...");
            while (object != null) {
                System.out.println(object.getMessage());
                object = object.getCause();
            }
            System.exit(1);
        }
        object = requestResource.getRequestStatus();
        System.out.println(object.getExecutionStatus());
        tupleToWebRowSetCharArrays.getResultOutput().setDeliverToRequestStatusActivity(deliverToRequestStatus);
        if (tupleToWebRowSetCharArrays.hasNextResult()) {
            int n;
            Object object2;
            ResultSet resultSet = tupleToWebRowSetCharArrays.nextResultAsResultSet();
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            String[] stringArray2 = new String[n2];
            int[] nArray = new int[n2];
            for (int i = 0; i < n2; ++i) {
                object2 = resultSetMetaData.getColumnLabel(i + 1);
                stringArray2[i] = object2;
                nArray[i] = ((String)object2).length();
            }
            Vector<Object> vector = new Vector<Object>();
            while (resultSet.next()) {
                object2 = new String[n2];
                for (n = 0; n < n2; ++n) {
                    object2[n] = resultSet.getString(n + 1);
                    nArray[n] = Math.max(nArray[n], ((String)object2[n]).length());
                }
                vector.add(object2);
            }
            resultSet.close();
            object2 = "| ";
            for (n = 0; n < n2; ++n) {
                object2 = (String)object2 + SQLClient.pad(stringArray2[n], nArray[n]) + " | ";
            }
            System.out.println((String)object2);
            for (n = 0; n < vector.size(); ++n) {
                String[] stringArray3 = (String[])vector.get(n);
                String string = "| ";
                for (int i = 0; i < n2; ++i) {
                    string = string + SQLClient.pad(stringArray3[i], nArray[i]) + " | ";
                }
                System.out.println(string);
            }
        }
    }

    protected void applySecurityToResource(Resource resource) {
    }

    protected void processParameters(Map map) {
        String string;
        this.mURL = super.getSingleValueOptionalFlag(map, URL);
        if (this.mURL == null) {
            this.mURL = "http://localhost:8080/dai/services/";
        }
        if ((string = super.getSingleValueOptionalFlag(map, DRER)) == null) {
            string = "DataRequestExecutionResource";
        }
        this.mDrerID = new ResourceID(string);
        String string2 = super.getSingleValueOptionalFlag(map, DATA_RESOURCE);
        if (string2 == null) {
            string2 = "JDBCResource";
        }
        this.mDataResourceID = new ResourceID(string2);
        this.mSQLQuery = super.getSingleValue(map, QUERY);
    }

    protected void printArguments() {
        System.out.println("DRER ID: " + this.mDrerID);
        System.out.println("Data Resource ID: " + this.mDataResourceID);
        System.out.println("Base Services URL: " + this.mURL);
        System.out.println("SQLQuery: " + this.mSQLQuery);
    }

    public static String pad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = n - string.length();
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }
}

