/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.example;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import uk.org.ogsadai.client.toolkit.DataIterator;
import uk.org.ogsadai.client.toolkit.DataRequestExecutionResource;
import uk.org.ogsadai.client.toolkit.PipelineWorkflow;
import uk.org.ogsadai.client.toolkit.RequestExecutionType;
import uk.org.ogsadai.client.toolkit.RequestResource;
import uk.org.ogsadai.client.toolkit.ServerProxy;
import uk.org.ogsadai.client.toolkit.activities.delivery.DeliverToRequestStatus;
import uk.org.ogsadai.client.toolkit.activities.file.ListDirectory;
import uk.org.ogsadai.client.toolkit.activities.file.ReadFromFile;
import uk.org.ogsadai.client.toolkit.example.ClientBase;
import uk.org.ogsadai.resource.ResourceID;

public class FileClient
extends ClientBase {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final String LIST_DIR = "list";
    private static final String READ_FILE = "read";
    private static final String URL = "u";
    private static final String DRER = "e";
    private static final String DATA_RESOURCE = "d";
    private static final String COMMAND = "c";
    private static final String FILE = "f";
    private static final String DIR = "dir";

    public static void main(String[] stringArray) throws Exception {
        FileClient fileClient = new FileClient();
        fileClient.execute(stringArray);
    }

    public void execute(String[] stringArray) throws Exception {
        String string;
        Hashtable hashtable = new Hashtable();
        super.parseArguments(stringArray, hashtable);
        String string2 = super.getSingleValueOptionalFlag(hashtable, URL);
        if (string2 == null) {
            string2 = "http://localhost:8080/dai/services/";
        }
        if ((string = super.getSingleValueOptionalFlag(hashtable, DRER)) == null) {
            string = "DataRequestExecutionResource";
        }
        ResourceID resourceID = new ResourceID(string);
        String string3 = super.getSingleValueOptionalFlag(hashtable, DATA_RESOURCE);
        if (string3 == null) {
            string3 = "FileResource";
        }
        ResourceID resourceID2 = new ResourceID(string3);
        String string4 = super.getSingleValue(hashtable, COMMAND);
        String string5 = null;
        String string6 = null;
        if (string4.equals(LIST_DIR)) {
            string5 = this.getSingleValueOptionalFlag(hashtable, DIR);
        } else if (string4.equals(READ_FILE)) {
            string6 = this.getSingleValue(hashtable, FILE);
        } else {
            throw new IllegalArgumentException("value for flag -c must be one of: read or list");
        }
        System.out.println("DRER ID: " + resourceID);
        System.out.println("Data Resource ID: " + resourceID2);
        System.out.println("Base Services URL: " + string2);
        System.out.println("Command: " + string4);
        if (string5 != null) {
            System.out.println("Directory: " + string5);
        }
        if (string6 != null) {
            System.out.println("File: " + string6);
        }
        ServerProxy serverProxy = new ServerProxy();
        serverProxy.setDefaultBaseServicesURL(new URL(string2));
        DataRequestExecutionResource dataRequestExecutionResource = serverProxy.getDataRequestExecutionResource(resourceID);
        if (string4.equals(LIST_DIR)) {
            FileClient.listDirectory(dataRequestExecutionResource, resourceID2, string5);
        } else if (string4.equals(READ_FILE)) {
            FileClient.readFromFile(dataRequestExecutionResource, resourceID2, string6);
        }
    }

    private static void listDirectory(DataRequestExecutionResource dataRequestExecutionResource, ResourceID resourceID, String string) throws Exception {
        Object object;
        ListDirectory listDirectory = new ListDirectory();
        listDirectory.setResourceID(resourceID);
        listDirectory.addIncludePath(true);
        listDirectory.addRecursive(true);
        if (string != null) {
            listDirectory.addDirectory(string);
        }
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(listDirectory.getDataOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(listDirectory);
        pipelineWorkflow.add(deliverToRequestStatus);
        RequestResource requestResource = null;
        try {
            requestResource = dataRequestExecutionResource.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        }
        catch (Throwable throwable) {
            System.out.println("A problem has occured...");
            while (object != null) {
                System.out.println(object.getMessage());
                object = object.getCause();
            }
            System.exit(1);
        }
        object = requestResource.getRequestStatus();
        System.out.println(object.getExecutionStatus());
        while (listDirectory.hasNextData()) {
            DataIterator dataIterator = listDirectory.nextData();
            while (dataIterator.hasNext()) {
                System.out.println(dataIterator.next());
            }
        }
    }

    private static void readFromFile(DataRequestExecutionResource dataRequestExecutionResource, ResourceID resourceID, String string) throws Exception {
        Object object;
        ReadFromFile readFromFile = new ReadFromFile();
        readFromFile.setResourceID(resourceID);
        readFromFile.addFile(string);
        DeliverToRequestStatus deliverToRequestStatus = new DeliverToRequestStatus();
        deliverToRequestStatus.connectInput(readFromFile.getDataOutput());
        PipelineWorkflow pipelineWorkflow = new PipelineWorkflow();
        pipelineWorkflow.add(readFromFile);
        pipelineWorkflow.add(deliverToRequestStatus);
        RequestResource requestResource = null;
        try {
            requestResource = dataRequestExecutionResource.execute(pipelineWorkflow, RequestExecutionType.SYNCHRONOUS);
        }
        catch (Throwable throwable) {
            System.out.println("A problem has occured...");
            while (object != null) {
                System.out.println(object.getMessage());
                object = object.getCause();
            }
            System.exit(1);
        }
        object = requestResource.getRequestStatus();
        System.out.println(object.getExecutionStatus());
        while (readFromFile.hasNextData()) {
            InputStream inputStream = readFromFile.getNextData();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string2 = null;
            while ((string2 = bufferedReader.readLine()) != null) {
                System.out.println(string2);
            }
        }
    }
}

