/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import uk.org.ogsadai.activity.ActivityInstanceName;
import uk.org.ogsadai.activity.ActivityStatus;
import uk.org.ogsadai.client.toolkit.DataSourceDataValueIterator;
import uk.org.ogsadai.client.toolkit.DataSourceResource;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.SimpleDataValueIterator;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.StreamErrorDataValueIterator;
import uk.org.ogsadai.client.toolkit.activities.delivery.DeliverToRequestStatus;
import uk.org.ogsadai.client.toolkit.activity.ActivityOutputRequestStatusHandler;
import uk.org.ogsadai.client.toolkit.exception.ActivityOutputUnconnectedException;
import uk.org.ogsadai.client.toolkit.exception.ActivityOutputUnreadableException;
import uk.org.ogsadai.resource.request.RequestStatus;
import uk.org.ogsadai.util.UniqueName;

public class SimpleSingleActivityOutput
implements SingleActivityOutput,
ActivityOutputRequestStatusHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static boolean OPTIONAL = true;
    public static boolean REQUIRED = false;
    private final String mOutputName;
    private final String mPipeName;
    private final boolean mIsOptional;
    private boolean mIsConnected;
    private final Map mAttributes;
    private ActivityInstanceName mRequestStatusActivityInstanceName;
    private String mRequestStatusResultName;
    private RequestStatus mRequestStatus;
    private DataValueIterator mDataValueIterator = null;

    public SimpleSingleActivityOutput(String string) {
        this(string, REQUIRED);
    }

    public SimpleSingleActivityOutput(String string, boolean bl) {
        this.mOutputName = string;
        this.mPipeName = UniqueName.newName();
        this.mIsOptional = bl;
        this.mIsConnected = false;
        this.mAttributes = new HashMap();
        this.mRequestStatusActivityInstanceName = null;
        this.mRequestStatusResultName = null;
        this.mRequestStatus = null;
    }

    public String getOutputName() {
        return this.mOutputName;
    }

    public String getPipeName() {
        return this.mPipeName;
    }

    public void setIsConnected() {
        this.mIsConnected = true;
    }

    public boolean getIsConnected() {
        return this.mIsConnected;
    }

    public void setRequestStatusDetails(ActivityInstanceName activityInstanceName, String string) {
        this.mRequestStatusActivityInstanceName = activityInstanceName;
        this.mRequestStatusResultName = string;
    }

    public ActivityInstanceName getRequestStatusActivityInstanceName() {
        return this.mRequestStatusActivityInstanceName;
    }

    public String getRequestStatusResultName() {
        return this.mRequestStatusResultName;
    }

    public boolean hasData() {
        if (this.mRequestStatus == null) {
            return false;
        }
        return this.mRequestStatus.hasData(this.mRequestStatusActivityInstanceName, this.mRequestStatusResultName);
    }

    public DataValueIterator getDataValueIterator() {
        if (this.mDataValueIterator == null && this.mRequestStatus != null) {
            Iterator iterator = this.mRequestStatus.getDataValueIterator(this.mRequestStatusActivityInstanceName, this.mRequestStatusResultName);
            this.mDataValueIterator = new SimpleDataValueIterator(iterator);
            ActivityStatus activityStatus = this.mRequestStatus.getActivityProcessingStatus(this.mRequestStatusActivityInstanceName).getStatus();
            if (activityStatus == ActivityStatus.ERROR || activityStatus == ActivityStatus.TERMINATED) {
                this.mDataValueIterator = new StreamErrorDataValueIterator(this.mDataValueIterator);
            }
        }
        if (this.mDataValueIterator == null) {
            throw new ActivityOutputUnreadableException(this);
        }
        return this.mDataValueIterator;
    }

    public void setDeliverToRequestStatusActivity(DeliverToRequestStatus deliverToRequestStatus) {
        this.setRequestStatusDetails(deliverToRequestStatus.getInstanceName(), deliverToRequestStatus.getResultName());
    }

    public void setDataSourceResource(DataSourceResource dataSourceResource) {
        this.mDataValueIterator = new DataSourceDataValueIterator(dataSourceResource);
    }

    public void setDataSourceResourceBlocksSize(int n) {
        if (this.mDataValueIterator != null && this.mDataValueIterator instanceof DataSourceDataValueIterator) {
            DataSourceDataValueIterator dataSourceDataValueIterator = (DataSourceDataValueIterator)this.mDataValueIterator;
            dataSourceDataValueIterator.setNumBlocksPerCall(n);
        }
    }

    public void processRequestStatus(RequestStatus requestStatus) {
        this.mRequestStatus = requestStatus;
    }

    public ActivityOutputRequestStatusHandler getRequestStatusHandler() {
        return this;
    }

    public void validateState() throws ActivityOutputUnconnectedException {
        if (!this.mIsOptional && !this.mIsConnected) {
            throw new ActivityOutputUnconnectedException(this.mOutputName);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Output {\n");
        stringBuffer.append("  name = ");
        stringBuffer.append(this.mOutputName);
        stringBuffer.append("\n  optional = ");
        stringBuffer.append(this.mIsOptional);
        stringBuffer.append("\n  connected = ");
        stringBuffer.append(this.mIsConnected);
        stringBuffer.append("\n  pipe = Pipe[");
        stringBuffer.append(this.mPipeName);
        stringBuffer.append("]\n");
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

