/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputDescriptor;
import uk.org.ogsadai.client.toolkit.activity.PipeInputDescriptor;
import uk.org.ogsadai.client.toolkit.activity.SimpleLiteralInputDescriptor;
import uk.org.ogsadai.client.toolkit.activity.SimplePipeInputDescriptor;
import uk.org.ogsadai.client.toolkit.activity.SingleActivityInput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.ActivityInputConflictException;
import uk.org.ogsadai.client.toolkit.exception.ActivityInputUnspecifiedException;
import uk.org.ogsadai.data.DataValue;

public class SimpleSingleActivityInput
implements SingleActivityInput {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,   2007.";
    public static boolean OPTIONAL = true;
    public static boolean REQUIRED = false;
    private final String mName;
    private final boolean mIsOptional;
    private PipeInputDescriptor mPipeInput;
    private SimpleLiteralInputDescriptor mLiteralInput;

    public SimpleSingleActivityInput(String string) {
        this(string, REQUIRED);
    }

    public SimpleSingleActivityInput(String string, boolean bl) {
        this.mName = string;
        this.mIsOptional = bl;
        this.mPipeInput = null;
        this.mLiteralInput = null;
    }

    public void add(DataValue dataValue) {
        if (this.mLiteralInput == null) {
            this.mLiteralInput = new SimpleLiteralInputDescriptor(this.mName);
        }
        this.mLiteralInput.add(dataValue);
    }

    public void connect(SingleActivityOutput singleActivityOutput) {
        this.mPipeInput = new SimplePipeInputDescriptor(this.mName, singleActivityOutput.getPipeName());
        singleActivityOutput.setIsConnected();
    }

    public ActivityInputDescriptor getInputDescriptor() {
        if (this.mPipeInput != null) {
            return this.mPipeInput;
        }
        return this.mLiteralInput;
    }

    public void validateState() throws ActivityIOIllegalStateException {
        if (!this.mIsOptional && !this.isOperational()) {
            throw new ActivityInputUnspecifiedException(this.mName);
        }
        if (this.mPipeInput != null && this.mLiteralInput != null) {
            throw new ActivityInputConflictException(this.mName);
        }
        if (this.mLiteralInput != null) {
            this.mLiteralInput.validateInputData();
        }
    }

    public boolean isOperational() {
        return this.mPipeInput != null || this.mLiteralInput != null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Input {\n");
        stringBuffer.append("  name = ");
        stringBuffer.append(this.mName);
        stringBuffer.append("\n  optional = ");
        stringBuffer.append(this.mIsOptional);
        stringBuffer.append("\n  operational = ");
        stringBuffer.append(this.isOperational());
        if (this.mPipeInput != null) {
            stringBuffer.append("\n  pipe = ");
            stringBuffer.append(this.mPipeInput);
            stringBuffer.append("\n");
        } else if (this.mLiteralInput != null) {
            stringBuffer.append("\n  literals:\n");
            String string = this.mLiteralInput.toString();
            string = string.replaceAll("\n", "\n    ");
            string = string.replaceAll("\n    $", "\n");
            stringBuffer.append("    ");
            stringBuffer.append(string);
        } else {
            stringBuffer.append("\n");
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

