/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputDescriptorVisitor;
import uk.org.ogsadai.client.toolkit.activity.LiteralInputDescriptor;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.ActivityInputUnmatchedListBeginException;
import uk.org.ogsadai.client.toolkit.exception.ActivityInputUnmatchedListEndException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;

public class SimpleLiteralInputDescriptor
implements LiteralInputDescriptor {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2007.";
    private final String mInputName;
    private final List mItems;

    public SimpleLiteralInputDescriptor(String string) {
        this.mInputName = string;
        this.mItems = new LinkedList();
    }

    public void add(DataValue dataValue) {
        this.mItems.add(dataValue);
    }

    public String getInputName() {
        return this.mInputName;
    }

    public void accept(ActivityInputDescriptorVisitor activityInputDescriptorVisitor) {
        activityInputDescriptorVisitor.visitLiteralInputDescriptor(this);
    }

    public Iterator iterator() {
        return this.mItems.iterator();
    }

    public void validateInputData() throws ActivityIOIllegalStateException {
        int n = 0;
        Iterator iterator = this.mItems.iterator();
        while (iterator.hasNext()) {
            DataValue dataValue = (DataValue)iterator.next();
            if (dataValue == ListBegin.VALUE) {
                ++n;
                continue;
            }
            if (dataValue != ListEnd.VALUE || --n >= 0) continue;
            throw new ActivityInputUnmatchedListEndException(this.mInputName);
        }
        if (n > 0) {
            throw new ActivityInputUnmatchedListBeginException(this.mInputName);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.mItems.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

