/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataSourceResource;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.SimpleSingleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.ActivityOutputUnreadableException;

public class SimpleActivityOutput
implements ActivityOutput {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static boolean OPTIONAL = true;
    public static boolean REQUIRED = false;
    private final String mOutputName;
    private final boolean mIsOptional;
    private SingleActivityOutput[] mSingleOutputs;

    public SimpleActivityOutput(String string) {
        this(string, REQUIRED);
    }

    public SimpleActivityOutput(String string, boolean bl) {
        this.mOutputName = string;
        this.mIsOptional = bl;
        this.mSingleOutputs = new SimpleSingleActivityOutput[1];
        this.mSingleOutputs[0] = new SimpleSingleActivityOutput(string, this.mIsOptional);
    }

    public String getOutputName() {
        return this.mOutputName;
    }

    public String getPipeName() {
        return this.getPipeName(0);
    }

    public boolean hasData() {
        return this.hasData(0);
    }

    public DataValueIterator getDataValueIterator() {
        return this.getDataValueIterator(0);
    }

    public void validateState() throws ActivityIOIllegalStateException {
        for (int i = 0; i < this.mSingleOutputs.length; ++i) {
            this.mSingleOutputs[i].validateState();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mSingleOutputs.length; ++i) {
            stringBuffer.append("Occurence with index " + i + ":\n");
            stringBuffer.append(this.mSingleOutputs[i].toString());
        }
        return stringBuffer.toString();
    }

    public int getNumberOfOutputs() {
        return this.mSingleOutputs.length;
    }

    public SingleActivityOutput[] getSingleActivityOutputs() {
        return this.mSingleOutputs;
    }

    public DataValueIterator getDataValueIterator(int n) throws ActivityOutputUnreadableException, ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.mSingleOutputs.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.mSingleOutputs[n].getDataValueIterator();
    }

    public boolean hasData(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.mSingleOutputs.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.mSingleOutputs[n].hasData();
    }

    public String getPipeName(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.mSingleOutputs.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.mSingleOutputs[n].getPipeName();
    }

    public void setNumberOfOutputs(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.mSingleOutputs = new SimpleSingleActivityOutput[n];
        for (int i = 0; i < n; ++i) {
            this.mSingleOutputs[i] = new SimpleSingleActivityOutput(this.mOutputName, this.mIsOptional);
        }
    }

    public void setDataSourceResource(int n, DataSourceResource dataSourceResource) {
        if (n < 0 || n > this.mSingleOutputs.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mSingleOutputs[n].setDataSourceResource(dataSourceResource);
    }

    public void setDataSourceResourceBlocksSize(int n, int n2) {
        if (n < 0 || n > this.mSingleOutputs.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mSingleOutputs[n].setDataSourceResourceBlocksSize(n2);
    }

    public void setDataSourceResource(DataSourceResource dataSourceResource) {
        this.mSingleOutputs[0].setDataSourceResource(dataSourceResource);
    }

    public void setDataSourceResourceBlocksSize(int n) {
        this.mSingleOutputs[0].setDataSourceResourceBlocksSize(n);
    }
}

