/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleSingleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SingleActivityInput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.data.DataValue;

public class SimpleActivityInput
implements ActivityInput {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static boolean OPTIONAL = true;
    public static boolean REQUIRED = false;
    private final String mName;
    private final boolean mIsOptional;
    private SingleActivityInput[] mSingleInputs;

    public SimpleActivityInput(String string) {
        this(string, REQUIRED);
    }

    public SimpleActivityInput(String string, boolean bl) {
        this.mName = string;
        this.mIsOptional = bl;
        this.mSingleInputs = new SimpleSingleActivityInput[1];
        this.mSingleInputs[0] = new SimpleSingleActivityInput(this.mName, this.mIsOptional);
    }

    public void add(DataValue dataValue) {
        this.add(0, dataValue);
    }

    public void connect(SingleActivityOutput singleActivityOutput) {
        this.connect(0, singleActivityOutput);
    }

    public void validateState() throws ActivityIOIllegalStateException {
        for (int i = 0; i < this.mSingleInputs.length; ++i) {
            this.mSingleInputs[i].validateState();
        }
    }

    public boolean isOperational() {
        for (int i = 0; i < this.mSingleInputs.length; ++i) {
            if (!this.mSingleInputs[i].isOperational()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.mSingleInputs.length; ++i) {
            stringBuffer.append("Occurence with index " + i + ":\n");
            stringBuffer.append(this.mSingleInputs[i].toString());
        }
        return stringBuffer.toString();
    }

    public void add(int n, DataValue dataValue) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.mSingleInputs.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mSingleInputs[n].add(dataValue);
    }

    public void connect(int n, SingleActivityOutput singleActivityOutput) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n > this.mSingleInputs.length - 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.mSingleInputs[n].connect(singleActivityOutput);
    }

    public void setNumberOfInputs(int n) {
        if (n < 1) {
            throw new IllegalArgumentException();
        }
        this.mSingleInputs = new SimpleSingleActivityInput[n];
        for (int i = 0; i < n; ++i) {
            this.mSingleInputs[i] = new SimpleSingleActivityInput(this.mName, this.mIsOptional);
        }
    }

    public int getNumberOfInputs() {
        return this.mSingleInputs.length;
    }

    public SingleActivityInput[] getSingleActivityInputs() {
        return this.mSingleInputs;
    }
}

