/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import uk.org.ogsadai.activity.ActivityInstanceName;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.activity.ActivityStatus;
import uk.org.ogsadai.activity.event.Warning;
import uk.org.ogsadai.activity.request.status.ActivityProcessingStatus;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInputDescriptor;
import uk.org.ogsadai.client.toolkit.activity.RequestAndStatusHandler;
import uk.org.ogsadai.client.toolkit.activity.RequestBuilder;
import uk.org.ogsadai.client.toolkit.activity.SingleActivityInput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.ActivityIllegalStateException;
import uk.org.ogsadai.client.toolkit.messages.Message;
import uk.org.ogsadai.exception.DAIException;
import uk.org.ogsadai.resource.ResourceID;
import uk.org.ogsadai.resource.request.RequestStatus;
import uk.org.ogsadai.util.UniqueName;

public abstract class BaseActivity
implements Activity,
RequestAndStatusHandler {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private ActivityName mActivityName;
    private ActivityInstanceName mActivityInstanceName;
    private ActivityStatus mActivityStatus;
    private ActivityProcessingStatus mActivityProcessingStatus;
    private Server mServer;

    public BaseActivity(ActivityName activityName) {
        this.setActivityName(activityName);
        this.mActivityInstanceName = new ActivityInstanceName(activityName + "-" + UniqueName.newName());
        this.mActivityStatus = null;
    }

    public ActivityName getActivityName() {
        return this.mActivityName;
    }

    public ActivityInstanceName getInstanceName() {
        return this.mActivityInstanceName;
    }

    public ActivityStatus getStatus() {
        return this.mActivityStatus;
    }

    public boolean hasErrorMessages() {
        boolean bl = false;
        if (this.mActivityProcessingStatus != null && this.mActivityProcessingStatus.getError() != null) {
            bl = true;
        }
        return bl;
    }

    public Message[] getErrorMessages() {
        DAIException dAIException;
        Message[] messageArray = new Message[]{};
        if (this.mActivityProcessingStatus != null && (dAIException = this.mActivityProcessingStatus.getError()) != null) {
            messageArray = Message.buildMessageArrayFromDAIException(dAIException);
        }
        return messageArray;
    }

    public boolean hasWarnings() {
        boolean bl = false;
        if (this.mActivityProcessingStatus != null) {
            bl = this.mActivityProcessingStatus.getWarnings().hasNext();
        }
        return bl;
    }

    public Message[] getWarnings() {
        Message[] messageArray = new Message[]{};
        if (this.mActivityProcessingStatus != null) {
            Iterator iterator = this.mActivityProcessingStatus.getWarnings();
            ArrayList<Message> arrayList = new ArrayList<Message>();
            while (iterator.hasNext()) {
                Warning warning = (Warning)iterator.next();
                Object[] objectArray = warning.getParameters();
                String[] stringArray = new String[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    stringArray[i] = objectArray[i].toString();
                }
                Message message = new Message(warning.getMessageID().toString(), stringArray);
                arrayList.add(message);
            }
            messageArray = arrayList.toArray(new Message[0]);
        }
        return messageArray;
    }

    public void setActivityName(ActivityName activityName) {
        this.mActivityName = activityName;
    }

    public RequestAndStatusHandler getRequestAndStatusHandler() {
        return this;
    }

    public void setServer(Server server) {
        this.mServer = server;
    }

    public void buildRequest(RequestBuilder requestBuilder) throws ActivityIllegalStateException {
        this.validateState();
        requestBuilder.addActivity(this.getActivityName(), this.getInstanceName(), this.getInputDescriptors(), this.getConnectedOutputs(this.getOutputs()));
    }

    public void processRequestStatus(RequestStatus requestStatus) {
        this.mActivityStatus = requestStatus.getActivityStatus(this.mActivityInstanceName);
        this.mActivityProcessingStatus = requestStatus.getActivityProcessingStatus(this.mActivityInstanceName);
        ActivityOutput[] activityOutputArray = this.getOutputs();
        for (int i = 0; i < activityOutputArray.length; ++i) {
            for (int j = 0; j < activityOutputArray[i].getSingleActivityOutputs().length; ++j) {
                activityOutputArray[i].getSingleActivityOutputs()[j].getRequestStatusHandler().processRequestStatus(requestStatus);
            }
        }
    }

    protected Server getServer() {
        return this.mServer;
    }

    protected ActivityInputDescriptor[] getInputDescriptors() {
        ArrayList<ActivityInputDescriptor> arrayList = new ArrayList<ActivityInputDescriptor>();
        ActivityInput[] activityInputArray = this.getInputs();
        for (int i = 0; i < activityInputArray.length; ++i) {
            if (!activityInputArray[i].isOperational()) continue;
            SingleActivityInput[] singleActivityInputArray = activityInputArray[i].getSingleActivityInputs();
            for (int j = 0; j < singleActivityInputArray.length; ++j) {
                arrayList.add(singleActivityInputArray[j].getInputDescriptor());
            }
        }
        return arrayList.toArray(new ActivityInputDescriptor[0]);
    }

    protected void validateState() throws ActivityIllegalStateException {
        try {
            ActivityInput[] activityInputArray = this.getInputs();
            for (int i = 0; i < activityInputArray.length; ++i) {
                activityInputArray[i].validateState();
            }
            ActivityOutput[] activityOutputArray = this.getOutputs();
            for (int i = 0; i < activityOutputArray.length; ++i) {
                activityOutputArray[i].validateState();
            }
            this.validateIOState();
        }
        catch (ActivityIOIllegalStateException activityIOIllegalStateException) {
            throw new ActivityIllegalStateException(this.mActivityName, this.mActivityInstanceName, activityIOIllegalStateException);
        }
    }

    protected abstract void validateIOState() throws ActivityIOIllegalStateException;

    protected abstract ActivityInput[] getInputs();

    protected abstract ActivityOutput[] getOutputs();

    protected SingleActivityOutput[] getConnectedOutputs(ActivityOutput[] activityOutputArray) {
        LinkedList<SingleActivityOutput> linkedList = new LinkedList<SingleActivityOutput>();
        for (int i = 0; i < activityOutputArray.length; ++i) {
            for (int j = 0; j < activityOutputArray[i].getNumberOfOutputs(); ++j) {
                if (!activityOutputArray[i].getSingleActivityOutputs()[j].getIsConnected()) continue;
                linkedList.add(activityOutputArray[i].getSingleActivityOutputs()[j]);
            }
        }
        return linkedList.toArray(new SingleActivityOutput[0]);
    }

    public String toString() {
        return this.writeToString(false, null);
    }

    protected String writeToString(boolean bl, ResourceID resourceID) {
        ActivityOutput[] activityOutputArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Activity {\n");
        stringBuffer.append("  name = ");
        stringBuffer.append(this.mActivityName);
        stringBuffer.append("\n");
        stringBuffer.append("  instance name = ");
        stringBuffer.append(this.mActivityInstanceName);
        stringBuffer.append("\n");
        if (bl) {
            stringBuffer.append("  resource ID = ");
            stringBuffer.append(resourceID == null ? "UNSPECIFIED" : resourceID.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append("  status = ");
        stringBuffer.append(this.mActivityStatus == null ? "none" : this.mActivityStatus.toString());
        stringBuffer.append("\n");
        ActivityInput[] activityInputArray = this.getInputs();
        if (activityInputArray.length > 0) {
            stringBuffer.append("  inputs:\n");
            for (int i = 0; i < activityInputArray.length; ++i) {
                String string = activityInputArray[i].toString();
                string = string.replaceAll("\n", "\n    ");
                string = string.replaceAll("\n    $", "\n");
                stringBuffer.append("    ");
                stringBuffer.append(string);
            }
        }
        if ((activityOutputArray = this.getOutputs()).length > 0) {
            stringBuffer.append("  outputs:\n");
            for (int i = 0; i < activityOutputArray.length; ++i) {
                String string = activityOutputArray[i].toString();
                string = string.replaceAll("\n", "\n    ");
                string = string.replaceAll("\n    $", "\n");
                stringBuffer.append("    ");
                stringBuffer.append(string);
            }
        }
        if (this.hasErrorMessages()) {
            stringBuffer.append("  error:\n");
            Message[] messageArray = this.getErrorMessages();
            for (int i = 0; i < messageArray.length; ++i) {
                stringBuffer.append("    ");
                stringBuffer.append(messageArray[i].toString());
                stringBuffer.append("\n");
            }
        }
        if (this.hasWarnings()) {
            stringBuffer.append("  warnings:\n");
            Message[] messageArray = this.getWarnings();
            for (int i = 0; i < messageArray.length; ++i) {
                stringBuffer.append("    ");
                stringBuffer.append(messageArray[i].toString());
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("}\n");
        return stringBuffer.toString();
    }
}

