/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.xmldb;

import java.io.Reader;
import java.util.Iterator;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueReader;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseResourceActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.StringData;

public class XPathQuery
extends BaseResourceActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2002 - 2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.XPathQuery");
    public static final String INPUT_COLLECTION = "collection";
    public static final String INPUT_RESOURCEID = "resourceId";
    public static final String INPUT_NAMESPACE = "namespace";
    public static final String INPUT_EXPRESSION = "expression";
    private ActivityInput mCollectionInput = new SimpleActivityInput("collection", SimpleActivityInput.OPTIONAL);
    private ActivityInput mResourceIDInput = new SimpleActivityInput("resourceId", SimpleActivityInput.OPTIONAL);
    private ActivityInput mNamespaceInput = new SimpleActivityInput("namespace", SimpleActivityInput.OPTIONAL);
    private ActivityInput mExpressionInput = new SimpleActivityInput("expression", SimpleActivityInput.REQUIRED);
    public static final String DATA_OUTPUT = "data";
    private ActivityOutput mDataOutput = new SimpleActivityOutput("data");

    public XPathQuery() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void connectNamespaceInput(SingleActivityOutput singleActivityOutput) {
        if (singleActivityOutput == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.mNamespaceInput.connect(singleActivityOutput);
    }

    public void addNamespace(Iterator iterator) {
        this.mNamespaceInput.add((DataValue)ListBegin.VALUE);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof String)) {
                    throw new IllegalArgumentException("Namespace should be a String");
                }
                this.mNamespaceInput.add((DataValue)new StringData((String)e));
            }
        }
        this.mNamespaceInput.add((DataValue)ListEnd.VALUE);
    }

    public void connectCollectionInput(SingleActivityOutput singleActivityOutput) {
        if (singleActivityOutput == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.mCollectionInput.connect(singleActivityOutput);
    }

    public void addCollection(String string) {
        if (string == null) {
            throw new IllegalArgumentException("collection must not be null");
        }
        this.mCollectionInput.add((DataValue)new StringData(string));
    }

    public void connectResourceIDInput(SingleActivityOutput singleActivityOutput) {
        if (singleActivityOutput == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.mResourceIDInput.connect(singleActivityOutput);
    }

    public void addResourceID(String string) {
        if (string == null) {
            throw new IllegalArgumentException("resourceID must not be null");
        }
        this.mResourceIDInput.add((DataValue)new StringData(string));
    }

    public void connectExpressionInput(SingleActivityOutput singleActivityOutput) {
        if (singleActivityOutput == null) {
            throw new IllegalArgumentException("output must not be null");
        }
        this.mExpressionInput.connect(singleActivityOutput);
    }

    public void addExpression(String string) {
        if (string == null) {
            throw new IllegalArgumentException("expression must not be null");
        }
        this.mExpressionInput.add((DataValue)new StringData(string));
    }

    public SingleActivityOutput getDataOutput() {
        return this.mDataOutput.getSingleActivityOutputs()[0];
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mCollectionInput, this.mResourceIDInput, this.mNamespaceInput, this.mExpressionInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mDataOutput};
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().hasNext();
    }

    public Reader getNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (!this.hasNextResult()) {
            return null;
        }
        return new DataValueReader(this.mDataOutput.getDataValueIterator(), 1);
    }
}

