/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.xmldb;

import java.util.ArrayList;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataIterator;
import uk.org.ogsadai.client.toolkit.DataListIterator;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseResourceActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.StringData;

public class XMLListResources
extends BaseResourceActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.XMLListResources");
    public static final String INPUT_PARENT_COLLECTION = "parentCollection";
    private ActivityInput mParentCollectionInput = new SimpleActivityInput("parentCollection", true);
    public static final String DATA_OUTPUT = "data";
    private ActivityOutput mDataOutput = new SimpleActivityOutput("data");

    public XMLListResources() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addParentCollection(String string) {
        this.mParentCollectionInput.add((DataValue)new StringData(string));
    }

    public void connectParentCollectionInput(SingleActivityOutput singleActivityOutput) {
        this.mParentCollectionInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getDataOutput() {
        return this.mDataOutput.getSingleActivityOutputs()[0];
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mParentCollectionInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mDataOutput};
    }

    public boolean hasNextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().hasNext();
    }

    public DataIterator nextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (!this.hasNextData()) {
            return null;
        }
        return new DataListIterator(this.mDataOutput.getDataValueIterator(), String.class);
    }

    public String[] nextDataAsArray() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (!this.hasNextData()) {
            return null;
        }
        DataIterator dataIterator = this.nextData();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (dataIterator.hasNext()) {
            arrayList.add((String)dataIterator.next());
        }
        int n = arrayList.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }
}

