/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.Utilities;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;

public class Echo
extends BaseActivity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.Echo");
    private static final int BLOCK_SIZE = 2048;
    private SimpleActivityInput mInput = new SimpleActivityInput("input");
    private SimpleActivityInput mErrorInput = new SimpleActivityInput("errorAt", SimpleActivityInput.OPTIONAL);
    public static final String INPUT = "input";
    public static final String ERROR_AT = "errorAt";
    public static final String OUTPUT = "output";
    public static final int NEVER = -2;
    public static final int END = -1;
    private SimpleActivityOutput mOutput = new SimpleActivityOutput("output");

    public Echo() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addInput(DataValue dataValue) {
        this.mInput.add(dataValue);
    }

    public void addInput(char[] cArray) {
        this.mInput.add((DataValue)new CharData(cArray));
    }

    public void addInput(byte[] byArray) {
        this.mInput.add((DataValue)new BinaryData(byArray));
    }

    public void addInput(Float f) {
        this.addInput(f.floatValue());
    }

    public void addInput(float f) {
        this.mInput.add((DataValue)new FloatData(f));
    }

    public void addInput(Double d) {
        this.addInput((double)d);
    }

    public void addInput(double d) {
        this.mInput.add((DataValue)new DoubleData(d));
    }

    public void addInput(Integer n) {
        this.addInput((int)n);
    }

    public void addInput(int n) {
        this.mInput.add((DataValue)new IntegerData(n));
    }

    public void addInput(Long l) {
        this.addInput((long)l);
    }

    public void addInput(long l) {
        this.mInput.add((DataValue)new LongData(l));
    }

    public void addInput(Boolean bl) {
        this.addInput((boolean)bl);
    }

    public void addInput(boolean bl) {
        this.mInput.add((DataValue)new BooleanData(bl));
    }

    public void addInput(Date date) {
        this.mInput.add((DataValue)new DateData(date));
    }

    public void addInput(Calendar calendar) {
        this.addInput(calendar.getTime());
    }

    public void addInput(InputStream inputStream) throws IOException {
        this.mInput.add((DataValue)ListBegin.VALUE);
        Utilities.readBinaryData(this.mInput, inputStream, 2048);
        this.mInput.add((DataValue)ListEnd.VALUE);
    }

    public void addListBeginToInput() {
        this.mInput.add((DataValue)ListBegin.VALUE);
    }

    public void addListEndToInput() {
        this.mInput.add((DataValue)ListEnd.VALUE);
    }

    public void addInput(String string) {
        this.mInput.add((DataValue)new StringData(string));
    }

    public void insertErrorAt(int n) {
        this.mErrorInput.add((DataValue)new IntegerData(n));
    }

    public void connectInput(SingleActivityOutput singleActivityOutput) {
        this.mInput.connect(singleActivityOutput);
    }

    public void connectErrorInput(SingleActivityOutput singleActivityOutput) {
        this.mErrorInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getOutput() {
        return this.mOutput.getSingleActivityOutputs()[0];
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mInput, this.mErrorInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mOutput};
    }
}

