/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.util;

import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataIterator;
import uk.org.ogsadai.client.toolkit.DataListIterator;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.IntegerData;

public class DQPPattern
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh,  2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.DQPPattern");
    private SimpleActivityInput mNumDataSinksInput = new SimpleActivityInput("numDataSinks");
    private SimpleActivityOutput mURLOutput = new SimpleActivityOutput("url");
    private SimpleActivityOutput mResourceIDsOutput = new SimpleActivityOutput("resourceIDs");
    private SimpleActivityOutput mResultOutput = new SimpleActivityOutput("result");

    public DQPPattern() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void connextNumDataSinksInput(SingleActivityOutput singleActivityOutput) {
        this.mNumDataSinksInput.connect(singleActivityOutput);
    }

    public void addNumDataSinksInput(int n) {
        this.mNumDataSinksInput.add((DataValue)new IntegerData(n));
    }

    public boolean hasNextURL() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mURLOutput.getDataValueIterator().hasNext();
    }

    public String nextURL() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mURLOutput.getDataValueIterator().nextAsString();
    }

    public boolean hasNextResourceIDs() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mResourceIDsOutput.getDataValueIterator().hasNext();
    }

    public DataIterator nextResourceIDs() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return new DataListIterator(this.mResourceIDsOutput.getDataValueIterator(), String.class);
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mResultOutput.getDataValueIterator().hasNext();
    }

    public int nextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mResultOutput.getDataValueIterator().nextAsInt();
    }

    public SingleActivityOutput getResultOutput() {
        return this.mResultOutput.getSingleActivityOutputs()[0];
    }

    public SingleActivityOutput getResourceIDsOutput() {
        return this.mResourceIDsOutput.getSingleActivityOutputs()[0];
    }

    public SingleActivityOutput getURLOutput() {
        return this.mURLOutput.getSingleActivityOutputs()[0];
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mNumDataSinksInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mURLOutput, this.mResultOutput, this.mResourceIDsOutput};
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }
}

