/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.transform;

import java.io.IOException;
import java.io.Reader;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueReader;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.Utilities;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;

public class XSLTransform
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.XSLTransform");
    private static final DAILogger LOG = DAILogger.getLogger((Class)XSLTransform.class);
    public static final String INPUT_XSLT = "xslt";
    private ActivityInput mXSLTInput = new SimpleActivityInput("xslt");
    public static final String INPUT_XML = "xml";
    private ActivityInput mXMLInput = new SimpleActivityInput("xml");
    public static final String DATA_OUTPUT = "result";
    private ActivityOutput mDataOutput = new SimpleActivityOutput("result");
    public static final int BLOCK_SIZE = 2048;

    public XSLTransform() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addXSLT(Reader reader) throws IOException {
        this.mXSLTInput.add((DataValue)ListBegin.VALUE);
        Utilities.readCharData(this.mXSLTInput, reader, 2048);
        this.mXSLTInput.add((DataValue)ListEnd.VALUE);
    }

    public void addXML(Reader reader) throws IOException {
        this.mXMLInput.add((DataValue)ListBegin.VALUE);
        Utilities.readCharData(this.mXMLInput, reader, 2048);
        this.mXMLInput.add((DataValue)ListEnd.VALUE);
    }

    public void connectXSLTInput(SingleActivityOutput singleActivityOutput) {
        this.mXSLTInput.connect(singleActivityOutput);
    }

    public void connectXMLInput(SingleActivityOutput singleActivityOutput) {
        this.mXMLInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getResultOutput() {
        return this.mDataOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().hasNext();
    }

    public Reader nextResult() {
        return new DataValueReader(this.mDataOutput.getDataValueIterator(), 1);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mXSLTInput, this.mXMLInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mDataOutput};
    }
}

