/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.transform;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.DataValueReader;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.converters.webrowset.WebRowSetResultSetParseException;
import uk.org.ogsadai.converters.webrowset.resultset.WebRowSetToResultSet;

public class WebRowSetToResultSetDataRetriever {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private final DataValueIterator mDataValueIterator;
    private int mListDepth;
    private Reader mReader;

    public WebRowSetToResultSetDataRetriever(ActivityOutput activityOutput) {
        this.mDataValueIterator = activityOutput.getDataValueIterator();
        this.mListDepth = 1;
    }

    public void setListDepth(int n) {
        this.mListDepth = n;
    }

    public boolean hasNext() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        this.closeReader();
        return this.mDataValueIterator.hasNext();
    }

    public ResultSet next() throws WebRowSetResultSetParseException {
        this.closeReader();
        this.mReader = new DataValueReader(this.mDataValueIterator, this.mListDepth);
        WebRowSetToResultSet webRowSetToResultSet = new WebRowSetToResultSet(this.mReader);
        webRowSetToResultSet.setResultSetType(1003);
        ResultSet resultSet = webRowSetToResultSet.getResultSet();
        return resultSet;
    }

    private void closeReader() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mReader = null;
        }
    }
}

