/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.transform;

import java.io.Reader;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueReader;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.StringData;

public class TupleToCSV
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.TupleToCSV");
    public static final String INPUT_DATA = "data";
    public static final String INPUT_DELIMITER = "delimiter";
    public static final String INPUT_LINEBREAK = "lineBreak";
    public static final String INPUT_NULLDATASTRING = "nullDataString";
    public static final String INPUT_INCLUDEHEADER = "includeHeader";
    public static final String INPUT_ESCAPEFIELDS = "escapeFields";
    private ActivityInput mDataInput = new SimpleActivityInput("data");
    private ActivityInput mDelimiterInput = new SimpleActivityInput("delimiter", true);
    private ActivityInput mLineBreakInput = new SimpleActivityInput("lineBreak", true);
    private ActivityInput mNullDataStringInput = new SimpleActivityInput("nullDataString", true);
    private ActivityInput mIncludeHeaderInput = new SimpleActivityInput("includeHeader", true);
    private ActivityInput mEscapeFieldsInput = new SimpleActivityInput("escapeFields", true);
    public static final String RESULT_OUTPUT = "result";
    private ActivityOutput mResultOutput = new SimpleActivityOutput("result");

    public TupleToCSV() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void connectDataInput(SingleActivityOutput singleActivityOutput) {
        this.mDataInput.connect(singleActivityOutput);
    }

    public void addDelimiter(String string) {
        this.mDelimiterInput.add((DataValue)new StringData(string));
    }

    public void addLineBreak(String string) {
        this.mLineBreakInput.add((DataValue)new StringData(string));
    }

    public void addNullDataString(String string) {
        this.mNullDataStringInput.add((DataValue)new StringData(string));
    }

    public void addIncludeHeader(boolean bl) {
        this.mIncludeHeaderInput.add((DataValue)new BooleanData(bl));
    }

    public void addEscapeFields(boolean bl) {
        this.mEscapeFieldsInput.add((DataValue)new BooleanData(bl));
    }

    public void connectDelimiterInput(SingleActivityOutput singleActivityOutput) {
        this.mDelimiterInput.connect(singleActivityOutput);
    }

    public void connectLineBreakInput(SingleActivityOutput singleActivityOutput) {
        this.mLineBreakInput.connect(singleActivityOutput);
    }

    public void connectNullDataStringInput(SingleActivityOutput singleActivityOutput) {
        this.mNullDataStringInput.connect(singleActivityOutput);
    }

    public void connectIncludeHeaderInput(SingleActivityOutput singleActivityOutput) {
        this.mIncludeHeaderInput.connect(singleActivityOutput);
    }

    public void connectEscapeFieldsInput(SingleActivityOutput singleActivityOutput) {
        this.mEscapeFieldsInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getResultOutput() {
        return this.mResultOutput.getSingleActivityOutputs()[0];
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mDataInput, this.mDelimiterInput, this.mLineBreakInput, this.mNullDataStringInput, this.mIncludeHeaderInput, this.mEscapeFieldsInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mResultOutput};
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mResultOutput.getDataValueIterator().hasNext();
    }

    public Reader nextResult() {
        return new DataValueReader(this.mResultOutput.getDataValueIterator(), 1);
    }
}

