/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.transform;

import java.io.IOException;
import java.io.Reader;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueReader;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.converters.databaseschema.RelationalSchemaParseException;
import uk.org.ogsadai.converters.databaseschema.TableMetaData;
import uk.org.ogsadai.converters.databaseschema.fromxml.XMLToSchemaConverterImpl;

public class TableMetadataToXMLCharArrays
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.TableMetadataToXMLCharArrays");
    public static final String DATA_INPUT = "data";
    public static final String RESULT_OUTPUT = "result";
    private ActivityInput mDataInput = new SimpleActivityInput("data");
    private ActivityOutput mResultOutput = new SimpleActivityOutput("result");
    private Reader mReader;

    public TableMetadataToXMLCharArrays() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void connectDataInput(SingleActivityOutput singleActivityOutput) {
        this.mDataInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getResultOutput() {
        return this.mResultOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        this.closeReader();
        return this.mResultOutput.getDataValueIterator().hasNext();
    }

    public Reader nextResult() {
        this.closeReader();
        this.mReader = new DataValueReader(this.mResultOutput.getDataValueIterator(), 1);
        return this.mReader;
    }

    public TableMetaData nextResultAsTableMetaData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException, RelationalSchemaParseException {
        this.mReader = this.nextResult();
        return new XMLToSchemaConverterImpl().read(this.mReader);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
        this.mDataInput.validateState();
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mDataInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mResultOutput};
    }

    private void closeReader() {
        if (this.mReader != null) {
            try {
                this.mReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.mReader = null;
        }
    }
}

