/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.transform;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.Utilities;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.common.msgs.DAILogger;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.StringData;

public class CSVToTuple
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.CSVToTuple");
    private static final DAILogger LOG = DAILogger.getLogger((Class)CSVToTuple.class);
    public static final String INPUT_DATA = "data";
    private ActivityInput mDataInput = new SimpleActivityInput("data");
    public static final String INPUT_DELIMITER = "delimiter";
    private ActivityInput mDelimiterInput = new SimpleActivityInput("delimiter", SimpleActivityInput.OPTIONAL);
    public static final String INPUT_NULLDATASTRING = "nullDataString";
    private ActivityInput mNullDataStringInput = new SimpleActivityInput("nullDataString", SimpleActivityInput.OPTIONAL);
    public static final String INPUT_HEADERINCLUDED = "headerIncluded";
    private ActivityInput mHeaderIncludedInput = new SimpleActivityInput("headerIncluded", SimpleActivityInput.OPTIONAL);
    public static final String INPUT_OUTPUTTYPES = "outputTypes";
    private ActivityInput mOutputTypesInput = new SimpleActivityInput("outputTypes", SimpleActivityInput.OPTIONAL);
    public static final String RESULT_OUTPUT = "result";
    private ActivityOutput mResultOutput = new SimpleActivityOutput("result");
    public static final int BLOCK_SIZE = 2048;

    public CSVToTuple() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addData(Reader reader) throws IOException {
        this.mDataInput.add((DataValue)ListBegin.VALUE);
        Utilities.readCharData(this.mDataInput, reader, 2048);
        this.mDataInput.add((DataValue)ListEnd.VALUE);
    }

    public void addDelimiter(String string) {
        this.mDelimiterInput.add((DataValue)new StringData(string));
    }

    public void addNullDataString(String string) {
        this.mNullDataStringInput.add((DataValue)new StringData(string));
    }

    public void addHeaderIncluded(boolean bl) {
        this.mHeaderIncludedInput.add((DataValue)new BooleanData(bl));
    }

    public void addOutputTypes(Iterator iterator) {
        this.mOutputTypesInput.add((DataValue)ListBegin.VALUE);
        while (iterator.hasNext()) {
            this.mOutputTypesInput.add((DataValue)new IntegerData(((Integer)iterator.next()).intValue()));
        }
        this.mOutputTypesInput.add((DataValue)ListEnd.VALUE);
    }

    public void addOutputTypesAsArray(int[] nArray) {
        this.mOutputTypesInput.add((DataValue)ListBegin.VALUE);
        for (int i = 0; i < nArray.length; ++i) {
            this.mOutputTypesInput.add((DataValue)new IntegerData(nArray[i]));
        }
        this.mOutputTypesInput.add((DataValue)ListEnd.VALUE);
    }

    public void connectDataInput(SingleActivityOutput singleActivityOutput) {
        this.mDataInput.connect(singleActivityOutput);
    }

    public void connectDelimiterInput(SingleActivityOutput singleActivityOutput) {
        this.mDelimiterInput.connect(singleActivityOutput);
    }

    public void connectNullDataStringInput(SingleActivityOutput singleActivityOutput) {
        this.mNullDataStringInput.connect(singleActivityOutput);
    }

    public void connectHeaderIncludedInput(SingleActivityOutput singleActivityOutput) {
        this.mHeaderIncludedInput.connect(singleActivityOutput);
    }

    public void connectOutputTypesInput(SingleActivityOutput singleActivityOutput) {
        this.mOutputTypesInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getResultOutput() {
        return this.mResultOutput.getSingleActivityOutputs()[0];
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mDataInput, this.mDelimiterInput, this.mNullDataStringInput, this.mHeaderIncludedInput, this.mOutputTypesInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mResultOutput};
    }
}

