/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataIterator;
import uk.org.ogsadai.client.toolkit.DataListIterator;
import uk.org.ogsadai.client.toolkit.ResourceActivity;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseResourceActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.StringData;

public class SQLParameterisedUpdate
extends BaseResourceActivity
implements ResourceActivity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.SQLParameterisedUpdate");
    public static final String EXPRESSION_INPUT = "expression";
    public static final String PARAMETERS_INPUT = "parameters";
    public static final String UPDATE_RESULT = "result";
    private final ActivityInput mExpressionInput = new SimpleActivityInput("expression");
    private final ActivityInput mParametersInput = new SimpleActivityInput("parameters");
    private final ActivityOutput mResultOutput = new SimpleActivityOutput("result");

    public SQLParameterisedUpdate() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addExpression(String string) {
        this.mExpressionInput.add((DataValue)new StringData(string));
    }

    public void connectExpressionInput(SingleActivityOutput singleActivityOutput) {
        this.mExpressionInput.connect(singleActivityOutput);
    }

    public void connectParametersInput(SingleActivityOutput singleActivityOutput) {
        this.mParametersInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getResultOutput() {
        return this.mResultOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mResultOutput.getDataValueIterator().hasNext();
    }

    public DataIterator nextResult() {
        return new DataListIterator(this.mResultOutput.getDataValueIterator(), Integer.class);
    }

    public int[] nextResultAsArray() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (!this.hasNextResult()) {
            throw new NoSuchElementException();
        }
        return this.getIntegerArray(this.nextResult());
    }

    protected int[] getIntegerArray(DataIterator dataIterator) throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (dataIterator.hasNext()) {
            arrayList.add(dataIterator.next());
        }
        int[] nArray = new int[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Integer n2 = (Integer)iterator.next();
            nArray[n++] = n2;
        }
        return nArray;
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mExpressionInput, this.mParametersInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mResultOutput};
    }
}

