/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.management;

import java.util.Iterator;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.resource.ResourceID;

public class CreateResourceGroup
extends BaseActivity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static final String INPUT_GROUP_ID = "resourceGroupId";
    public static final String INPUT_IDS = "resourceIds";
    public static final String OUTPUT = "output";
    private final ActivityInput mResourceGroupIdInput = new SimpleActivityInput("resourceGroupId", SimpleActivityInput.OPTIONAL);
    private final ActivityInput mResourceIdsInput = new SimpleActivityInput("resourceIds", SimpleActivityInput.REQUIRED);
    private final ActivityOutput mResultOutput = new SimpleActivityOutput("output");
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.CreateResourceGroup");

    public CreateResourceGroup() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addResourceIds(Iterator iterator) {
        this.mResourceIdsInput.add((DataValue)ListBegin.VALUE);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String)) {
                throw new IllegalArgumentException("The resourceIds input should be String");
            }
            this.mResourceIdsInput.add((DataValue)new StringData((String)e));
        }
        this.mResourceIdsInput.add((DataValue)ListEnd.VALUE);
    }

    public void addResourceIdsAsArray(String[] stringArray) {
        this.mResourceIdsInput.add((DataValue)ListBegin.VALUE);
        for (int i = 0; i < stringArray.length; ++i) {
            this.mResourceIdsInput.add((DataValue)new StringData(stringArray[i]));
        }
        this.mResourceIdsInput.add((DataValue)ListEnd.VALUE);
    }

    public void addResourceGroupId(ResourceID resourceID) {
        this.mResourceGroupIdInput.add((DataValue)new StringData(resourceID.toString()));
    }

    public void connectResourceIdsInput(SingleActivityOutput singleActivityOutput) {
        this.mResourceIdsInput.connect(singleActivityOutput);
    }

    public void connectResourceGroupIdInput(SingleActivityOutput singleActivityOutput) {
        this.mResourceGroupIdInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getOutput() {
        return this.mResultOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mResultOutput.getDataValueIterator().hasNext();
    }

    public ResourceID nextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        String string = this.mResultOutput.getDataValueIterator().nextAsString();
        return new ResourceID(string);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mResourceIdsInput, this.mResourceGroupIdInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mResultOutput};
    }
}

