/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.management;

import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.resource.ResourceID;

public abstract class BaseCreateDataX
extends BaseActivity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static final String RESOURCE_ID_INPUT = "resourceId";
    public static final String OUTPUT = "result";
    private final ActivityInput mResourceIdInput = new SimpleActivityInput("resourceId", SimpleActivityInput.OPTIONAL);
    private final ActivityOutput mOutput = new SimpleActivityOutput("result");

    public BaseCreateDataX(ActivityName activityName) {
        super(activityName);
    }

    public void addResourceId(ResourceID resourceID) {
        this.mResourceIdInput.add((DataValue)new StringData(resourceID.toString()));
    }

    public void connectResourceIdInput(SingleActivityOutput singleActivityOutput) {
        this.mResourceIdInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getResultOutput() {
        return this.mOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mOutput.getDataValueIterator().hasNext();
    }

    public ResourceID nextResult() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        String string = this.mOutput.getDataValueIterator().nextAsString();
        return new ResourceID(string);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mResourceIdInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mOutput};
    }
}

