/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueInputStream;
import uk.org.ogsadai.client.toolkit.ResourceActivity;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseResourceActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;

public class ReadFromFile
extends BaseResourceActivity
implements ResourceActivity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.ReadFromFile");
    public static final String FILE_INPUT = "file";
    public static final String OFFSET_INPUT = "offset";
    public static final String LENGTH_INPUT = "length";
    public static final String OUTPUT_DATA = "data";
    private ActivityInput mFileInput = new SimpleActivityInput("file");
    private ActivityInput mOffsetInput = new SimpleActivityInput("offset", SimpleActivityInput.OPTIONAL);
    private ActivityInput mLengthInput = new SimpleActivityInput("length", SimpleActivityInput.OPTIONAL);
    private ActivityOutput mDataOutput = new SimpleActivityOutput("data");

    public ReadFromFile() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addFile(String string) {
        this.mFileInput.add((DataValue)new StringData(string));
    }

    public void addOffset(long l) {
        this.mOffsetInput.add((DataValue)new LongData(l));
    }

    public void addLength(long l) {
        this.mLengthInput.add((DataValue)new LongData(l));
    }

    public void connectFileInput(SingleActivityOutput singleActivityOutput) {
        this.mFileInput.connect(singleActivityOutput);
    }

    public void connectOffsetInput(SingleActivityOutput singleActivityOutput) {
        this.mOffsetInput.connect(singleActivityOutput);
    }

    public void connectLengthInput(SingleActivityOutput singleActivityOutput) {
        this.mLengthInput.connect(singleActivityOutput);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mFileInput, this.mOffsetInput, this.mLengthInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mDataOutput};
    }

    public SingleActivityOutput getDataOutput() {
        return this.mDataOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().hasNext();
    }

    public InputStream getNextData() {
        return new DataValueInputStream(this.mDataOutput.getDataValueIterator(), 1);
    }

    public byte[] getNextDataAsByteArray() throws IOException {
        InputStream inputStream = this.getNextData();
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 1024;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

