/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.file;

import java.util.ArrayList;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataIterator;
import uk.org.ogsadai.client.toolkit.DataListIterator;
import uk.org.ogsadai.client.toolkit.ResourceActivity;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseResourceActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.StringData;

public class ListDirectory
extends BaseResourceActivity
implements ResourceActivity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.ListDirectory");
    public static final String DIRECTORY_INPUT = "directory";
    public static final String INCLUDE_PATH_INPUT = "includePath";
    public static final String RECURSIVE_INPUT = "recursive";
    public static final String OUTPUT_DATA = "data";
    private ActivityInput mDirectoryInput = new SimpleActivityInput("directory", SimpleActivityInput.OPTIONAL);
    private ActivityInput mIncludePathInput = new SimpleActivityInput("includePath", SimpleActivityInput.OPTIONAL);
    private ActivityInput mRecursiveInput = new SimpleActivityInput("recursive", SimpleActivityInput.OPTIONAL);
    private ActivityOutput mDataOutput = new SimpleActivityOutput("data");

    public ListDirectory() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addDirectory(String string) {
        this.mDirectoryInput.add((DataValue)new StringData(string));
    }

    public void addIncludePath(boolean bl) {
        this.mIncludePathInput.add((DataValue)new BooleanData(bl));
    }

    public void addRecursive(boolean bl) {
        this.mRecursiveInput.add((DataValue)new BooleanData(bl));
    }

    public void connectDirectoryInput(SingleActivityOutput singleActivityOutput) {
        this.mDirectoryInput.connect(singleActivityOutput);
    }

    public void connectIncludePathInput(SingleActivityOutput singleActivityOutput) {
        this.mIncludePathInput.connect(singleActivityOutput);
    }

    public void connectRecursiveInput(SingleActivityOutput singleActivityOutput) {
        this.mRecursiveInput.connect(singleActivityOutput);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mDirectoryInput, this.mIncludePathInput, this.mRecursiveInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mDataOutput};
    }

    public SingleActivityOutput getDataOutput() {
        return this.mDataOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().hasNext();
    }

    public DataIterator nextData() {
        return new DataListIterator(this.mDataOutput.getDataValueIterator(), String.class);
    }

    public String[] nextDataAsArray() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        if (!this.hasNextData()) {
            return null;
        }
        DataIterator dataIterator = this.nextData();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (dataIterator.hasNext()) {
            arrayList.add(dataIterator.next());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

