/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.delivery;

import java.io.InputStream;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueInputStream;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.StringData;

public class ObtainFromGFTP
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.ObtainFromGFTP");
    private static final String INPUT_HOST = "host";
    private static final String INPUT_FILENAME = "filename";
    private static final String INPUT_PASSIVE_MODE = "passiveMode";
    private static final String INPUT_AUTHORIZATION = "authorization";
    private static final String OUTPUT_DATA = "data";
    private ActivityInput mHostInput = new SimpleActivityInput("host");
    private ActivityInput mFilenameInput = new SimpleActivityInput("filename");
    private ActivityInput mPassiveModeInput = new SimpleActivityInput("passiveMode", SimpleActivityInput.OPTIONAL);
    private ActivityInput mAuthorizationInput = new SimpleActivityInput("authorization", SimpleActivityInput.OPTIONAL);
    private ActivityOutput mDataOutput = new SimpleActivityOutput("data");

    public ObtainFromGFTP() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addHost(String string) {
        this.mHostInput.add((DataValue)new StringData(string));
    }

    public void connectHostInput(SingleActivityOutput singleActivityOutput) {
        this.mHostInput.connect(singleActivityOutput);
    }

    public void addFilename(String string) {
        this.mFilenameInput.add((DataValue)new StringData(string));
    }

    public void connectFilenameInput(SingleActivityOutput singleActivityOutput) {
        this.mFilenameInput.connect(singleActivityOutput);
    }

    public void addPassiveMode(boolean bl) {
        this.mPassiveModeInput.add((DataValue)new BooleanData(bl));
    }

    public void connectPassiveModeInput(SingleActivityOutput singleActivityOutput) {
        this.mPassiveModeInput.connect(singleActivityOutput);
    }

    public void addAuthorization(String string) {
        this.mAuthorizationInput.add((DataValue)new StringData(string));
    }

    public void connectAuthorizationInput(SingleActivityOutput singleActivityOutput) {
        this.mAuthorizationInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getDataOutput() {
        return this.mDataOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().hasNext();
    }

    public InputStream nextData() {
        DataValueInputStream dataValueInputStream = new DataValueInputStream(this.mDataOutput.getDataValueIterator(), 1);
        return dataValueInputStream;
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mHostInput, this.mFilenameInput, this.mPassiveModeInput, this.mAuthorizationInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mDataOutput};
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }
}

