/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.delivery;

import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.ModeType;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.resource.ResourceID;

public class ObtainFromDataSource
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.ObtainFromDataSource");
    public static final String FULL = "full";
    public static final String BLOCK = "block";
    public static final String INPUT_URL = "url";
    private ActivityInput mURLInput = new SimpleActivityInput("url");
    public static final String INPUT_RESOURCE_ID = "resourceID";
    private ActivityInput mResourceIDInput = new SimpleActivityInput("resourceID");
    public static final String INPUT_MODE = "mode";
    private ActivityInput mModeInput = new SimpleActivityInput("mode");
    public static final String INPUT_NUM_OF_BLOCKS = "numberOfBlocks";
    private ActivityInput mNumOfBlocksInput = new SimpleActivityInput("numberOfBlocks", true);
    public static final String OUTPUT_DATA = "data";
    private ActivityOutput mDataOutput = new SimpleActivityOutput("data");

    public ObtainFromDataSource() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addURL(String string) {
        this.mURLInput.add((DataValue)new StringData(string));
    }

    public void addResourceID(ResourceID resourceID) {
        this.mResourceIDInput.add((DataValue)new StringData(resourceID.toString()));
    }

    public void addMode(ModeType modeType) {
        this.mModeInput.add((DataValue)new StringData(modeType.toString()));
    }

    public void addNumOfBlocks(int n) {
        this.mNumOfBlocksInput.add((DataValue)new IntegerData(n));
    }

    public void connectURLInput(SingleActivityOutput singleActivityOutput) {
        this.mURLInput.connect(singleActivityOutput);
    }

    public void connectResourceIDInput(SingleActivityOutput singleActivityOutput) {
        this.mResourceIDInput.connect(singleActivityOutput);
    }

    public void connectModeInput(SingleActivityOutput singleActivityOutput) {
        this.mModeInput.connect(singleActivityOutput);
    }

    public void connectNumOfBlocksInput(SingleActivityOutput singleActivityOutput) {
        this.mNumOfBlocksInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getDataOutput() {
        return this.mDataOutput.getSingleActivityOutputs()[0];
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mURLInput, this.mResourceIDInput, this.mModeInput, this.mNumOfBlocksInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mDataOutput};
    }

    public boolean hasNextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().hasNext();
    }

    public Object nextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mDataOutput.getDataValueIterator().next();
    }
}

