/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.delivery;

import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.Utilities;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.StringData;

public class DeliverToSMTP
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    public static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.DeliverToSMTP");
    public static final String INPUT_TO = "to";
    private ActivityInput mToInput = new SimpleActivityInput("to");
    public static final String INPUT_FROM = "from";
    private ActivityInput mFromInput = new SimpleActivityInput("from");
    public static final String INPUT_SUBJECT = "subject";
    private ActivityInput mSubjectInput = new SimpleActivityInput("subject");
    public static final String INPUT_DATA = "data";
    private ActivityInput mDataInput = new SimpleActivityInput("data");
    public static final int BLOCK_SIZE = 2048;

    public DeliverToSMTP() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addTo(Iterator iterator) {
        this.mToInput.add((DataValue)ListBegin.VALUE);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String)) {
                throw new IllegalArgumentException("To input should be String");
            }
            this.mToInput.add((DataValue)new StringData((String)e));
        }
        this.mToInput.add((DataValue)ListEnd.VALUE);
    }

    public void addToAsArray(String[] stringArray) {
        this.mToInput.add((DataValue)ListBegin.VALUE);
        for (int i = 0; i < stringArray.length; ++i) {
            this.mToInput.add((DataValue)new StringData(stringArray[i]));
        }
        this.mToInput.add((DataValue)ListEnd.VALUE);
    }

    public void addFrom(String string) {
        this.mFromInput.add((DataValue)new StringData(string));
    }

    public void addSubject(String string) {
        this.mSubjectInput.add((DataValue)new StringData(string));
    }

    public void addData(Reader reader) throws IOException {
        this.mDataInput.add((DataValue)ListBegin.VALUE);
        Utilities.readCharData(this.mDataInput, reader, 2048);
        this.mDataInput.add((DataValue)ListEnd.VALUE);
    }

    public void connectToInput(SingleActivityOutput singleActivityOutput) {
        this.mToInput.connect(singleActivityOutput);
    }

    public void connectFromInput(SingleActivityOutput singleActivityOutput) {
        this.mFromInput.connect(singleActivityOutput);
    }

    public void connectSubjectInput(SingleActivityOutput singleActivityOutput) {
        this.mSubjectInput.connect(singleActivityOutput);
    }

    public void connectDataInput(SingleActivityOutput singleActivityOutput) {
        this.mDataInput.connect(singleActivityOutput);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mToInput, this.mFromInput, this.mSubjectInput, this.mDataInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[0];
    }
}

