/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.delivery;

import java.util.Calendar;
import java.util.Date;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.activity.ActivityStatus;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.SimpleDataValueIterator;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.StreamErrorDataValueIterator;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.RequestStatusUnknownException;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;
import uk.org.ogsadai.resource.request.RequestStatus;

public class DeliverToRequestStatus
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.DeliverToRequestStatus");
    public static final String INPUT = "input";
    private static final String RESULT_NAME = "result";
    private SimpleActivityInput mInput = new SimpleActivityInput("input");
    private RequestStatus mRequestStatus;

    public DeliverToRequestStatus() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addInput(String string) {
        this.mInput.add((DataValue)new StringData(string));
    }

    public void addInput(char[] cArray) {
        this.mInput.add((DataValue)new CharData(cArray));
    }

    public void addInput(byte[] byArray) {
        this.mInput.add((DataValue)new BinaryData(byArray));
    }

    public void addInput(Float f) {
        this.addInput(f.floatValue());
    }

    public void addInput(float f) {
        this.mInput.add((DataValue)new FloatData(f));
    }

    public void addInput(Double d) {
        this.addInput((double)d);
    }

    public void addInput(double d) {
        this.mInput.add((DataValue)new DoubleData(d));
    }

    public void addInput(Integer n) {
        this.addInput((int)n);
    }

    public void addInput(int n) {
        this.mInput.add((DataValue)new IntegerData(n));
    }

    public void addInput(Long l) {
        this.addInput((long)l);
    }

    public void addInput(long l) {
        this.mInput.add((DataValue)new LongData(l));
    }

    public void addInput(Boolean bl) {
        this.addInput((boolean)bl);
    }

    public void addInput(boolean bl) {
        this.mInput.add((DataValue)new BooleanData(bl));
    }

    public void addInput(Date date) {
        this.mInput.add((DataValue)new DateData(date));
    }

    public void addInput(Calendar calendar) {
        this.addInput(calendar.getTime());
    }

    public void connectInput(SingleActivityOutput singleActivityOutput) {
        this.mInput.connect(singleActivityOutput);
        singleActivityOutput.getRequestStatusHandler().setRequestStatusDetails(this.getInstanceName(), RESULT_NAME);
    }

    public String getResultName() {
        return RESULT_NAME;
    }

    public DataValueIterator getDataValueIterator() {
        if (this.mRequestStatus == null || !this.mRequestStatus.getExecutionStatus().hasFinished()) {
            throw new RequestStatusUnknownException();
        }
        DataValueIterator dataValueIterator = new SimpleDataValueIterator(this.mRequestStatus.getDataValueIterator(this.getInstanceName(), RESULT_NAME));
        ActivityStatus activityStatus = this.mRequestStatus.getActivityProcessingStatus(this.getInstanceName()).getStatus();
        if (activityStatus == ActivityStatus.ERROR || activityStatus == ActivityStatus.TERMINATED) {
            dataValueIterator = new StreamErrorDataValueIterator(dataValueIterator);
        }
        return dataValueIterator;
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
        this.mInput.validateState();
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[0];
    }

    public void processRequestStatus(RequestStatus requestStatus) {
        super.processRequestStatus(requestStatus);
        this.mRequestStatus = requestStatus;
    }
}

