/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.delivery;

import java.io.IOException;
import java.io.InputStream;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.Utilities;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.StringData;

public class DeliverToGFTP
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    public static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.DeliverToGFTP");
    private static final String INPUT_HOST = "host";
    private static final String INPUT_FILENAME = "filename";
    private static final String INPUT_DATA = "data";
    private static final String INPUT_PASSIVE_MODE = "passiveMode";
    private static final String INPUT_APPEND = "append";
    private static final String INPUT_AUTHORIZATION = "authorization";
    private static final int BLOCK_SIZE = 2048;
    private ActivityInput mHostInput = new SimpleActivityInput("host");
    private ActivityInput mFilenameInput = new SimpleActivityInput("filename");
    private ActivityInput mDataInput = new SimpleActivityInput("data");
    private ActivityInput mPassiveModeInput = new SimpleActivityInput("passiveMode", SimpleActivityInput.OPTIONAL);
    private ActivityInput mAppendInput = new SimpleActivityInput("append", SimpleActivityInput.OPTIONAL);
    private ActivityInput mAuthorizationInput = new SimpleActivityInput("authorization", SimpleActivityInput.OPTIONAL);

    public DeliverToGFTP() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addHost(String string) {
        this.mHostInput.add((DataValue)new StringData(string));
    }

    public void connectHostInput(SingleActivityOutput singleActivityOutput) {
        this.mHostInput.connect(singleActivityOutput);
    }

    public void addFilename(String string) {
        this.mFilenameInput.add((DataValue)new StringData(string));
    }

    public void connectFilenameInput(SingleActivityOutput singleActivityOutput) {
        this.mFilenameInput.connect(singleActivityOutput);
    }

    public void addData(InputStream inputStream) throws IOException {
        this.mDataInput.add((DataValue)ListBegin.VALUE);
        Utilities.readBinaryData(this.mDataInput, inputStream, 2048);
        this.mDataInput.add((DataValue)ListEnd.VALUE);
    }

    public void connectDataInput(SingleActivityOutput singleActivityOutput) {
        this.mDataInput.connect(singleActivityOutput);
    }

    public void addPassiveMode(boolean bl) {
        this.mPassiveModeInput.add((DataValue)new BooleanData(bl));
    }

    public void connectPassiveModeInput(SingleActivityOutput singleActivityOutput) {
        this.mPassiveModeInput.connect(singleActivityOutput);
    }

    public void addAppend(boolean bl) {
        this.mAppendInput.add((DataValue)new BooleanData(bl));
    }

    public void connectAppendInput(SingleActivityOutput singleActivityOutput) {
        this.mAppendInput.connect(singleActivityOutput);
    }

    public void addAuthorization(String string) {
        this.mAuthorizationInput.add((DataValue)new StringData(string));
    }

    public void connectAuthorizationInput(SingleActivityOutput singleActivityOutput) {
        this.mAuthorizationInput.connect(singleActivityOutput);
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mHostInput, this.mFilenameInput, this.mDataInput, this.mPassiveModeInput, this.mAppendInput, this.mAuthorizationInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[0];
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }
}

