/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.delivery;

import java.io.IOException;
import java.io.InputStream;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.Utilities;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.StringData;

public class DeliverToFTP
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    public static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.DeliverToFTP");
    public static final String INPUT_FILENAME = "filename";
    private ActivityInput mFilenameInput = new SimpleActivityInput("filename");
    public static final String INPUT_HOST = "host";
    private ActivityInput mHostInput = new SimpleActivityInput("host");
    public static final String INPUT_PASSIVEMODE = "passiveMode";
    private ActivityInput mPassiveModeInput = new SimpleActivityInput("passiveMode", true);
    public static final String INPUT_DATA = "data";
    private ActivityInput mDataInput = new SimpleActivityInput("data");
    public static final int BLOCK_SIZE = 2048;

    public DeliverToFTP() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addFilename(String string) {
        this.mFilenameInput.add((DataValue)new StringData(string));
    }

    public void addHost(String string) {
        this.mHostInput.add((DataValue)new StringData(string));
    }

    public void addPassiveMode(boolean bl) {
        this.mPassiveModeInput.add((DataValue)new BooleanData(bl));
    }

    public void addData(InputStream inputStream) throws IOException {
        this.mDataInput.add((DataValue)ListBegin.VALUE);
        Utilities.readBinaryData(this.mDataInput, inputStream, 2048);
        this.mDataInput.add((DataValue)ListEnd.VALUE);
    }

    public void connectFilenameInput(SingleActivityOutput singleActivityOutput) {
        this.mFilenameInput.connect(singleActivityOutput);
    }

    public void connectHostInput(SingleActivityOutput singleActivityOutput) {
        this.mHostInput.connect(singleActivityOutput);
    }

    public void connectPassiveModeInput(SingleActivityOutput singleActivityOutput) {
        this.mPassiveModeInput.connect(singleActivityOutput);
    }

    public void connectDataInput(SingleActivityOutput singleActivityOutput) {
        this.mDataInput.connect(singleActivityOutput);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mFilenameInput, this.mHostInput, this.mPassiveModeInput, this.mDataInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[0];
    }
}

