/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.block;

import java.util.Calendar;
import java.util.Date;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;

public class ListConcatenate
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.ListConcatenate");
    public static final String INPUT = "input";
    private SimpleActivityInput mInput = new SimpleActivityInput("input");
    public static final String INPUT_PARTIAL = "partial";
    private SimpleActivityInput mPartialInput = new SimpleActivityInput("partial", true);
    public static final String OUTPUT = "output";
    private SimpleActivityOutput mOutput = new SimpleActivityOutput("output");

    public ListConcatenate() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void setNumberOfInputs(int n) {
        this.mInput.setNumberOfInputs(n);
    }

    public void addInput(int n, String string) {
        this.mInput.add(n, (DataValue)new StringData(string));
    }

    public void addInput(int n, char[] cArray) {
        this.mInput.add(n, (DataValue)new CharData(cArray));
    }

    public void addInput(int n, byte[] byArray) {
        this.mInput.add(n, (DataValue)new BinaryData(byArray));
    }

    public void addInput(int n, Float f) {
        this.addInput(n, f.floatValue());
    }

    public void addInput(int n, float f) {
        this.mInput.add(n, (DataValue)new FloatData(f));
    }

    public void addInput(int n, Double d) {
        this.addInput(n, (double)d);
    }

    public void addInput(int n, double d) {
        this.mInput.add(n, (DataValue)new DoubleData(d));
    }

    public void addInput(int n, Integer n2) {
        this.addInput(n, (int)n2);
    }

    public void addInput(int n, int n2) {
        this.mInput.add(n, (DataValue)new IntegerData(n2));
    }

    public void addInput(int n, Long l) {
        this.addInput(n, (long)l);
    }

    public void addInput(int n, long l) {
        this.mInput.add(n, (DataValue)new LongData(l));
    }

    public void addInput(int n, Boolean bl) {
        this.addInput(n, (boolean)bl);
    }

    public void addInput(int n, boolean bl) {
        this.mInput.add(n, (DataValue)new BooleanData(bl));
    }

    public void addInput(int n, Date date) {
        this.mInput.add(n, (DataValue)new DateData(date));
    }

    public void addInput(int n, Calendar calendar) {
        this.addInput(n, calendar.getTime());
    }

    public void addListBeginToInput(int n) {
        this.mInput.add(n, (DataValue)ListBegin.VALUE);
    }

    public void addListEndToInput(int n) {
        this.mInput.add(n, (DataValue)ListEnd.VALUE);
    }

    public void addPartialInput(boolean bl) {
        this.mPartialInput.add((DataValue)new BooleanData(bl));
    }

    public void connectInput(int n, SingleActivityOutput singleActivityOutput) {
        this.mInput.connect(n, singleActivityOutput);
    }

    public void connectPartialInput(SingleActivityOutput singleActivityOutput) {
        this.mPartialInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getOutput() {
        return this.mOutput.getSingleActivityOutputs()[0];
    }

    public DataValueIterator getDataValueIterator() {
        return this.mOutput.getDataValueIterator();
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
        this.mInput.validateState();
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mInput, this.mPartialInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mOutput};
    }
}

