/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit.activities.block;

import java.util.Iterator;
import uk.org.ogsadai.activity.ActivityName;
import uk.org.ogsadai.client.toolkit.Activity;
import uk.org.ogsadai.client.toolkit.ActivityOutput;
import uk.org.ogsadai.client.toolkit.DataListIterator;
import uk.org.ogsadai.client.toolkit.SingleActivityOutput;
import uk.org.ogsadai.client.toolkit.activity.ActivityInput;
import uk.org.ogsadai.client.toolkit.activity.BaseActivity;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityInput;
import uk.org.ogsadai.client.toolkit.activity.SimpleActivityOutput;
import uk.org.ogsadai.client.toolkit.exception.ActivityIOIllegalStateException;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.ListBegin;
import uk.org.ogsadai.data.ListEnd;

public class ByteArraysResize
extends BaseActivity
implements Activity {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2002 - 2007.";
    public static final ActivityName DEFAULT_ACTIVITY_NAME = new ActivityName("uk.org.ogsadai.ByteArraysResize");
    public static final String DATA_INPUT = "data";
    public static final String SIZE_IN_BYTES_INPUT = "sizeInBytes";
    private ActivityInput mDataInput = new SimpleActivityInput("data");
    private ActivityInput mSizeInput = new SimpleActivityInput("sizeInBytes");
    public static final String OUTPUT = "result";
    private SimpleActivityOutput mOutput = new SimpleActivityOutput("result");

    public ByteArraysResize() {
        super(DEFAULT_ACTIVITY_NAME);
    }

    public void addSizeInBytes(int n) {
        this.mSizeInput.add((DataValue)new IntegerData(n));
    }

    public void connectSizeInBytesInput(SingleActivityOutput singleActivityOutput) {
        this.mSizeInput.connect(singleActivityOutput);
    }

    public void addData(Iterator iterator) {
        this.mDataInput.add((DataValue)ListBegin.VALUE);
        while (iterator.hasNext()) {
            this.mDataInput.add((DataValue)new BinaryData((byte[])iterator.next()));
        }
        this.mDataInput.add((DataValue)ListEnd.VALUE);
    }

    public void addData(byte[][] byArray) {
        this.mDataInput.add((DataValue)ListBegin.VALUE);
        for (int i = 0; i < byArray.length; ++i) {
            this.mDataInput.add((DataValue)new BinaryData(byArray[i]));
        }
        this.mDataInput.add((DataValue)ListEnd.VALUE);
    }

    public void connectDataInput(SingleActivityOutput singleActivityOutput) {
        this.mDataInput.connect(singleActivityOutput);
    }

    public SingleActivityOutput getResultOutput() {
        return this.mOutput.getSingleActivityOutputs()[0];
    }

    public boolean hasNextData() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return this.mOutput.getDataValueIterator().hasNext();
    }

    public DataListIterator getNextData() {
        return new DataListIterator(this.mOutput.getDataValueIterator(), [B.class);
    }

    protected void validateIOState() throws ActivityIOIllegalStateException {
    }

    protected ActivityInput[] getInputs() {
        return new ActivityInput[]{this.mDataInput, this.mSizeInput};
    }

    protected ActivityOutput[] getOutputs() {
        return new ActivityOutput[]{this.mOutput};
    }
}

