/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.util.Date;
import java.util.Iterator;
import uk.org.ogsadai.client.toolkit.DataValueIterator;
import uk.org.ogsadai.client.toolkit.exception.DataSourceUsageException;
import uk.org.ogsadai.client.toolkit.exception.DataStreamErrorException;
import uk.org.ogsadai.client.toolkit.exception.UnexpectedDataValueException;
import uk.org.ogsadai.data.BinaryData;
import uk.org.ogsadai.data.BooleanData;
import uk.org.ogsadai.data.CharData;
import uk.org.ogsadai.data.DataValue;
import uk.org.ogsadai.data.DataValueGetObjectVisitor;
import uk.org.ogsadai.data.DateData;
import uk.org.ogsadai.data.DoubleData;
import uk.org.ogsadai.data.FloatData;
import uk.org.ogsadai.data.IntegerData;
import uk.org.ogsadai.data.LongData;
import uk.org.ogsadai.data.StringData;

public class SimpleDataValueIterator
implements DataValueIterator {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007.";
    private Iterator mDataValueIterator;
    private DataValueGetObjectVisitor mDataValueGetObjectVisitor;

    public SimpleDataValueIterator(Iterator iterator) {
        this.mDataValueIterator = iterator;
    }

    public boolean hasNext() throws DataStreamErrorException, DataSourceUsageException {
        return this.mDataValueIterator.hasNext();
    }

    public DataValue next() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        return (DataValue)this.mDataValueIterator.next();
    }

    public boolean nextAsBoolean() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof BooleanData) {
            return ((BooleanData)dataValue).getBoolean();
        }
        throw new UnexpectedDataValueException(BooleanData.class, dataValue);
    }

    public byte[] nextAsByteArray() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof BinaryData) {
            return ((BinaryData)dataValue).getBytes();
        }
        throw new UnexpectedDataValueException(BinaryData.class, dataValue);
    }

    public char[] nextAsCharArray() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof CharData) {
            return ((CharData)dataValue).getChars();
        }
        throw new UnexpectedDataValueException(CharData.class, dataValue);
    }

    public String nextAsString() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof StringData) {
            return ((StringData)dataValue).toString();
        }
        throw new UnexpectedDataValueException(StringData.class, dataValue);
    }

    public Date nextAsDate() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof DateData) {
            return ((DateData)dataValue).getDate();
        }
        throw new UnexpectedDataValueException(DateData.class, dataValue);
    }

    public double nextAsDouble() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof DoubleData) {
            return ((DoubleData)dataValue).getDouble();
        }
        throw new UnexpectedDataValueException(DoubleData.class, dataValue);
    }

    public float nextAsFloat() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof FloatData) {
            return ((FloatData)dataValue).getFloat();
        }
        throw new UnexpectedDataValueException(FloatData.class, dataValue);
    }

    public int nextAsInt() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof IntegerData) {
            return ((IntegerData)dataValue).getInteger();
        }
        throw new UnexpectedDataValueException(IntegerData.class, dataValue);
    }

    public long nextAsLong() throws DataStreamErrorException, UnexpectedDataValueException, DataSourceUsageException {
        DataValue dataValue = (DataValue)this.mDataValueIterator.next();
        if (dataValue instanceof LongData) {
            return ((LongData)dataValue).getLong();
        }
        throw new UnexpectedDataValueException(LongData.class, dataValue);
    }
}

