/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.net.MalformedURLException;
import java.net.URL;
import uk.org.ogsadai.client.toolkit.AbstractServer;
import uk.org.ogsadai.client.toolkit.DataRequestExecutionResource;
import uk.org.ogsadai.client.toolkit.DataResource;
import uk.org.ogsadai.client.toolkit.DataSinkResource;
import uk.org.ogsadai.client.toolkit.DataSourceResource;
import uk.org.ogsadai.client.toolkit.RequestResource;
import uk.org.ogsadai.client.toolkit.Resource;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.ServerFactory;
import uk.org.ogsadai.client.toolkit.SessionResource;
import uk.org.ogsadai.client.toolkit.exception.ClientToolkitException;
import uk.org.ogsadai.client.toolkit.exception.ResourceUnknownException;
import uk.org.ogsadai.client.toolkit.exception.ServerCommsException;
import uk.org.ogsadai.client.toolkit.exception.ServerException;
import uk.org.ogsadai.resource.ResourceID;
import uk.org.ogsadai.resource.ResourceType;

public class ServerProxy
extends AbstractServer
implements Server {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh 2007";
    private Server mServer = null;

    public ServerProxy() {
        try {
            this.mBaseURL = new URL("http://localhost:8080/dai/services/");
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    public String getVersion(URL uRL) throws ServerCommsException, ServerException {
        Server server = ServerFactory.getServer(uRL);
        return server.getVersion(uRL);
    }

    public String getVersion(ResourceType resourceType) throws ServerCommsException, ServerException {
        return this.getServer().getVersion(resourceType);
    }

    public ResourceID[] listResources(URL uRL) throws ServerCommsException, ServerException {
        Server server = ServerFactory.getServer(uRL);
        return server.listResources(uRL);
    }

    public ResourceID[] listResources(ResourceType resourceType) throws ServerCommsException, ServerException {
        return this.getServer().listResources(resourceType);
    }

    public Resource getResource(URL uRL, ResourceID resourceID, ResourceType resourceType) throws ServerException, ClientToolkitException {
        if (ResourceType.DATA_REQUEST_EXECUTION_RESOURCE.equals((Object)resourceType)) {
            throw new IllegalArgumentException("resourceID cannot be " + ResourceType.DATA_REQUEST_EXECUTION_RESOURCE);
        }
        if (ResourceType.DATA_RESOURCE.equals((Object)resourceType)) {
            return this.getDataResource(uRL, resourceID);
        }
        if (ResourceType.DATA_SOURCE.equals((Object)resourceType)) {
            return this.getDataSourceResource(uRL, resourceID);
        }
        if (ResourceType.DATA_SINK.equals((Object)resourceType)) {
            return this.getDataSinkResource(uRL, resourceID);
        }
        if (ResourceType.SESSION.equals((Object)resourceType)) {
            return this.getSessionResource(uRL, resourceID);
        }
        if (ResourceType.REQUEST.equals((Object)resourceType)) {
            return this.getRequestResource(uRL, resourceID);
        }
        return null;
    }

    public Resource getResource(ResourceID resourceID, ResourceType resourceType) throws ServerException, ClientToolkitException {
        return this.getServer().getResource(resourceID, resourceType);
    }

    public DataRequestExecutionResource getDataRequestExecutionResource(ResourceID resourceID) throws ServerException, ClientToolkitException {
        return this.getServer().getDataRequestExecutionResource(resourceID);
    }

    public DataResource getDataResource(URL uRL, ResourceID resourceID) throws ServerException, ClientToolkitException {
        Server server = ServerFactory.getServer(uRL);
        return server.getDataResource(uRL, resourceID);
    }

    public DataResource getDataResource(ResourceID resourceID) throws ServerException, ClientToolkitException {
        return this.getServer().getDataResource(resourceID);
    }

    public DataSourceResource getDataSourceResource(URL uRL, ResourceID resourceID) throws ServerException, ClientToolkitException {
        Server server = ServerFactory.getServer(uRL);
        return server.getDataSourceResource(uRL, resourceID);
    }

    public DataSourceResource getDataSourceResource(ResourceID resourceID) throws ServerException, ClientToolkitException {
        return this.getServer().getDataSourceResource(resourceID);
    }

    public DataSinkResource getDataSinkResource(URL uRL, ResourceID resourceID) throws ServerException, ClientToolkitException {
        Server server = ServerFactory.getServer(uRL);
        return server.getDataSinkResource(uRL, resourceID);
    }

    public DataSinkResource getDataSinkResource(ResourceID resourceID) throws ServerException, ClientToolkitException {
        return this.getServer().getDataSinkResource(resourceID);
    }

    public SessionResource getSessionResource(URL uRL, ResourceID resourceID) throws ServerException, ClientToolkitException {
        Server server = ServerFactory.getServer(uRL);
        return server.getSessionResource(uRL, resourceID);
    }

    public SessionResource getSessionResource(ResourceID resourceID) throws ServerException, ClientToolkitException {
        return this.getServer().getSessionResource(resourceID);
    }

    public RequestResource getRequestResource(URL uRL, ResourceID resourceID) throws ServerException, ClientToolkitException {
        Server server = ServerFactory.getServer(uRL);
        return server.getRequestResource(uRL, resourceID);
    }

    public RequestResource getRequestResource(ResourceID resourceID) throws ServerException, ClientToolkitException {
        return this.getServer().getRequestResource(resourceID);
    }

    public String resolve(URL uRL, ResourceID resourceID) throws ResourceUnknownException, ServerCommsException, ServerException, ClientToolkitException {
        Server server = ServerFactory.getServer(uRL);
        return server.resolve(uRL, resourceID);
    }

    public String resolve(ResourceID resourceID, ResourceType resourceType) throws ResourceUnknownException, ServerCommsException, ServerException, ClientToolkitException {
        return this.getServer().resolve(resourceID, resourceType);
    }

    private Server getServer() {
        if (this.mServer == null || this.getHasConfigAltered()) {
            URL uRL = this.getDefaultServiceURL(ResourceType.DATA_REQUEST_EXECUTION_RESOURCE);
            this.mServer = ServerFactory.getServer(uRL);
            this.mServer.setDefaultBaseServicesURL(this.getDefaultBaseServicesURL());
            this.mServer.setDefaultDataRequestExecutionServiceName(this.getDefaultDataRequestExecutionServiceName());
            this.mServer.setDefaultDataResourceInformationServiceName(this.getDefaultDataResourceInformationServiceName());
            this.mServer.setDefaultDataSourceServiceName(this.getDefaultDataSourceServiceName());
            this.mServer.setDefaultDataSinkServiceName(this.getDefaultDataSinkServiceName());
            this.mServer.setDefaultSessionManagementServiceName(this.getDefaultSessionManagementServiceName());
            this.mServer.setDefaultRequestManagementServiceName(this.getDefaultRequestManagementServiceName());
            this.resetConfigAlteredFlag();
        }
        return this.mServer;
    }
}

