/*
 * Decompiled with CFR 0.152.
 */
package uk.org.ogsadai.client.toolkit;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import uk.org.ogsadai.client.toolkit.Server;
import uk.org.ogsadai.client.toolkit.exception.ClientToolkitException;
import uk.org.ogsadai.client.toolkit.exception.DAIClassNotFoundException;
import uk.org.ogsadai.client.toolkit.exception.PresentationLayerNotSupportedException;
import uk.org.ogsadai.client.toolkit.exception.ServerFactoryInitialisationException;
import uk.org.ogsadai.client.toolkit.exception.ServerInitialisationException;
import uk.org.ogsadai.client.toolkit.exception.ServerURLInvalidException;

public class ServerFactory {
    private static final String COPYRIGHT_NOTICE = "Copyright (c) The University of Edinburgh, 2007";
    private static final String WSRF_STRING = "wsrf.string";
    private static final String SERVER_CLASS = "server.class";
    private static final String PROPERTIES_FILE_NAME = "/uk/org/ogsadai/client/toolkit/presentation/config.properties";
    private static Map mServerMap;

    public static Server getServer(URL uRL) throws ClientToolkitException {
        URL uRL2;
        try {
            uRL2 = new URL(uRL.toExternalForm() + "?wsdl");
        }
        catch (MalformedURLException malformedURLException) {
            throw new ServerInitialisationException(malformedURLException);
        }
        String string = ServerFactory.getWSDL(uRL2);
        Map map = ServerFactory.getServerMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            if (string.indexOf(string2) < 0) continue;
            String string3 = (String)map.get(string2);
            try {
                Class<?> clazz = Class.forName(string3);
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Server server = (Server)constructor.newInstance(new Object[0]);
                return server;
            }
            catch (ClassNotFoundException classNotFoundException) {
                DAIClassNotFoundException dAIClassNotFoundException = new DAIClassNotFoundException(string3);
                throw dAIClassNotFoundException;
            }
            catch (Throwable throwable) {
                throw new ServerInitialisationException(throwable);
            }
        }
        throw new PresentationLayerNotSupportedException();
    }

    private static Map getServerMap() throws ServerFactoryInitialisationException {
        if (mServerMap != null) {
            return mServerMap;
        }
        mServerMap = new HashMap();
        try {
            InputStream inputStream = ServerFactory.class.getResourceAsStream(PROPERTIES_FILE_NAME);
            Properties properties = new Properties();
            properties.load(inputStream);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.endsWith(WSRF_STRING)) continue;
                String string2 = properties.getProperty(string);
                String string3 = string.substring(0, string.length() - WSRF_STRING.length());
                String string4 = string3 + SERVER_CLASS;
                String string5 = properties.getProperty(string4);
                mServerMap.put(string2, string5);
            }
            return mServerMap;
        }
        catch (Throwable throwable) {
            throw new ServerFactoryInitialisationException(PROPERTIES_FILE_NAME, throwable);
        }
    }

    private static String getWSDL(URL uRL) throws ClientToolkitException {
        try {
            int n;
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray = new char[1024];
            while ((n = inputStreamReader.read(cArray)) >= 0) {
                stringBuffer.append(cArray, 0, n);
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (IOException iOException) {
            ServerURLInvalidException serverURLInvalidException = new ServerURLInvalidException(uRL, iOException);
            throw serverURLInvalidException;
        }
    }
}

